#!/bin/sh

VERSION=`sed -n -e '1s/^ara (\([^ ]*\)) .*$/\1/p' debian/changelog`
DATE=`date +'%04Y-%02m-%02d'`

base=ara-$VERSION
dir=/tmp/$base
rm -rf /tmp/ara-$VERSION
mkdir $dir || exit 1
cp -a . $dir || exit 1
find $dir -type d -name '.svn' -exec rm -rf \{\} \; &>/dev/null
find $dir -type f -name '.depend' -exec rm -f \{\} \; &>/dev/null
find $dir -type f -name '.*.swp' -exec rm \{\} \; &>/dev/null
cd /tmp && tar cjf $dir.tar.bz2 $base
