(* Ara *)
(* $Id: ara.mli,v 1.1 2004/10/26 09:44:54 berke Exp $ *)

module Make : functor (Dpkg : Dpkg.DB) ->
  sig
    type statement = Ast.statement
    and query = Ast.set_query
    and result = Dpkg.IS.t

    val hierarchical : string -> string -> int
    val predicate : Ast.pattern -> string -> bool
    val eval_statement :
      get:(Ast.ident -> result) ->
      set:(Ast.ident -> result -> int -> int -> Ast.set_query -> 'a) ->
      ?cf:Ast.field_spec -> Dpkg.db -> Ast.statement -> result
    val sorted_list_of_query : Dpkg.db -> result -> int list
    val eval :
      get:(Ast.ident -> result) ->
      set:(Ast.ident -> result -> int -> int -> Ast.set_query -> 'a) ->
      cf:Ast.field_spec -> Dpkg.db -> Ast.set_query -> result
    val eval_atom :
      get:(Ast.ident -> result) ->
      set:(Ast.ident -> result -> int -> int -> Ast.set_query -> 'a) ->
      cf:Ast.field_spec -> Dpkg.db -> Ast.atomic_set -> result
    exception Parse_error of int * int * string
    val statement_of_string : string -> statement
    val compute_query :
      Dpkg.db ->
      get:(Ast.ident -> result) ->
      set:(Ast.ident -> result -> int -> int -> Ast.set_query -> 'a) ->
      Ast.statement -> int list
    val filter_old_versions : Dpkg.db -> int list -> int list
  end
