#
# -*- coding: utf-8 -*-
# Copyright 2024 Dell Inc. or its subsidiaries. All Rights Reserved
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The arg spec for the sonic_ospf_area module
"""

from __future__ import absolute_import, division, print_function
__metaclass__ = type


class Ospf_areaArgs(object):  # pylint: disable=R0903
    """The arg spec for the sonic_ospf_area module
    """

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        'config': {
            'elements': 'dict',
            'options': {
                'area_id': {'required': True, 'type': 'str'},
                'vrf_name': {'default': 'default', 'type': 'str'},
                'authentication_type': {'type': 'str', 'choices': ["message_digest", "text"]},
                'default_cost': {'type': 'int'},
                'filter_list_in': {'type': 'str'},
                'filter_list_out': {'type': 'str'},
                'networks': {
                    'elements': 'str',
                    'type': 'list'
                },
                'ranges': {
                    'elements': 'dict',
                    'options': {
                        'prefix': {'required': True, 'type': 'str'},
                        'advertise': {'type': 'bool'},
                        'cost': {'type': 'int'},
                        'substitute': {'type': 'str'}
                    },
                    'type': 'list'
                },
                'shortcut': {'type': 'str', 'choices': ['default', 'enable', 'disable']},
                'stub': {
                    'options': {
                        'enabled': {'type': 'bool'},
                        'no_summary': {'type': 'bool'}
                    },
                    'type': 'dict'
                },
                'virtual_links': {
                    'elements': 'dict',
                    'options': {
                        'router_id': {'type': 'str', 'required': True},
                        'enabled': {'type': 'bool'},
                        'dead_interval': {'type': 'int'},
                        'hello_interval': {'type': 'int'},
                        'retransmit_interval': {'type': 'int'},
                        'transmit_delay': {'type': 'int'},
                        'authentication': {
                            'options': {
                                'auth_type': {
                                    'type': 'str',
                                    'choices': ['message_digest', 'text', 'none']
                                },
                                'key': {'type': 'str', 'no_log': True},
                                'key_encrypted': {'type': 'bool'}
                            },
                            'type': 'dict'
                        },
                        'message_digest_list': {
                            'elements': 'dict',
                            'options': {
                                'key_id': {'type': 'int', 'required': True},
                                'key': {'type': 'str', 'no_log': True},
                                'key_encrypted': {'type': 'bool'}
                            },
                            'type': 'list'
                        }
                    },
                    'type': 'list'
                }
            },
            'type': 'list'
        },
        'state': {
            'choices': ['merged', 'deleted', 'replaced', 'overridden'],
            'default': 'merged',
            'type': 'str'
        }
    }  # pylint: disable=C0301
