#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2022, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of the Laborejo Software Suite ( https://www.laborejo.org ),

This application is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import logging; logger = logging.getLogger(__name__); logger.info("import")

#Standard Lib

#System Wide Modules
from PyQt5 import QtCore, QtWidgets, QtGui

#Local Modules
from engine.config import * #imports METADATA
from engine.start import PATHS

class Changelog(QtWidgets.QWidget):
    """
    A modal window that is hidden.
    Just shows the file CHANGELOG
    """

    def __init__(self, mainWindow):
        super().__init__()
        self.mainWindow = mainWindow

        ourLayout = QtWidgets.QVBoxLayout()
        #ourLayout.setSpacing(0)
        #ourLayout.setContentsMargins(0,0,0,0)
        self.setLayout(ourLayout)


        self.setWindowTitle(METADATA["name"] + " " +  QtCore.QCoreApplication.translate("TemplateChangelog", "Changelog"))
        introtext = QtCore.QCoreApplication.translate("TemplateChangelog", "The Changelog is only available in English.")
        ourLayout.addWidget(QtWidgets.QLabel(introtext))

        textEdit = QtWidgets.QPlainTextEdit()
        textEdit.setReadOnly(True)
        with open(PATHS["doc"] + "/CHANGELOG", "r") as f:
            textEdit.setPlainText(f.read())

        ourLayout.addWidget(textEdit)

        self.hide()

    def closeEvent(self, event):
        self.hide()
