MACRO(CHECK_MM_MALLOC)
SET(CMAKE_REQUIRED_FLAGS "${SSE_FLAGS}")
CHECK_C_SOURCE_COMPILES(
"#include <xmmintrin.h>
int main(){_mm_malloc(1024,16);}
" HAVE_MM_MALLOC)
SET(CMAKE_REQUIRED_FLAGS "")

IF(HAVE_MM_MALLOC)
  ADD_DEFINE(HAVE_MM_MALLOC)
ENDIF(HAVE_MM_MALLOC)
ENDMACRO(CHECK_MM_MALLOC)


MACRO(CHECK_POSIX_MEMALIGN)
CHECK_C_SOURCE_COMPILES(
"#define _XOPEN_SOURCE 600
#include <stdlib.h>
int main(){ void *test; posix_memalign(&test, 16, 1024); }
" HAVE_POSIX_MEMALIGN)
SET(CMAKE_REQUIRED_FLAGS "")

IF(HAVE_POSIX_MEMALIGN)
  ADD_DEFINE(HAVE_POSIX_MEMALIGN)
ENDIF(HAVE_POSIX_MEMALIGN)
ENDMACRO(CHECK_POSIX_MEMALIGN)


MACRO(CHECK_CASTSI128)
SET(CMAKE_REQUIRED_FLAGS "${SSE3_FLAGS}")
CHECK_C_SOURCE_COMPILES(
"#include <pmmintrin.h>
int main(){__m128i X; _mm_castsi128_ps(X);}
" HAVE_CASTSI128)
SET(CMAKE_REQUIRED_FLAGS "")

IF(NOT HAVE_CASTSI128)
  ADD_DEFINE(EMU_CASTSI128)
ENDIF(NOT HAVE_CASTSI128)
ENDMACRO(CHECK_CASTSI128)


MACRO(CHECK_MMX)
IF(CMAKE_COMPILER_IS_GNUCC)
  SET(MMX_FLAGS "-mmmx")
ENDIF(CMAKE_COMPILER_IS_GNUCC)

SET(CMAKE_REQUIRED_FLAGS "${MMX_FLAGS}")
CHECK_C_SOURCE_COMPILES(
"#include <mmintrin.h>
int main() {
__m64 X = _mm_setzero_si64();
__m64 Y = _mm_unpackhi_pi8(X, X);
_mm_empty();
}
" HAVE_MMX)
SET(CMAKE_REQUIRED_FLAGS "")
ENDMACRO(CHECK_MMX)


MACRO(CHECK_SSE)
IF(CMAKE_COMPILER_IS_GNUCC)
  SET(SSE_FLAGS "-mmmx -msse")
ENDIF(CMAKE_COMPILER_IS_GNUCC)

SET(CMAKE_REQUIRED_FLAGS "${SSE_FLAGS}")
CHECK_C_SOURCE_COMPILES(
"#include <xmmintrin.h>
int main(){__m128 X = _mm_setzero_ps();}
" HAVE_SSE)
SET(CMAKE_REQUIRED_FLAGS "")
ENDMACRO(CHECK_SSE)


MACRO(CHECK_SSE2)
IF(CMAKE_COMPILER_IS_GNUCC)
  SET(SSE2_FLAGS "-mmmx -msse -msse2")
ENDIF(CMAKE_COMPILER_IS_GNUCC)

SET(CMAKE_REQUIRED_FLAGS "${SSE2_FLAGS}")
CHECK_C_SOURCE_COMPILES(
"#include <emmintrin.h>
int main() {
__m128i X = _mm_setzero_si128();
__m128i Y = _mm_unpackhi_epi8(X, X);
}
" HAVE_SSE2)
SET(CMAKE_REQUIRED_FLAGS "")
ENDMACRO(CHECK_SSE2)


MACRO(CHECK_SSE3)
IF(CMAKE_COMPILER_IS_GNUCC)
  SET(SSE3_FLAGS "-mmmx -msse -msse2 -msse3")
ENDIF(CMAKE_COMPILER_IS_GNUCC)

SET(CMAKE_REQUIRED_FLAGS "${SSE3_FLAGS}")
CHECK_C_SOURCE_COMPILES(
"#include <pmmintrin.h>
int main() {
__m128 X = _mm_setzero_ps();
__m128 Y = _mm_movehdup_ps(X);
}
" HAVE_SSE3)
SET(CMAKE_REQUIRED_FLAGS "")
ENDMACRO(CHECK_SSE3)

MACRO(CHECK_ALTIVEC)
IF(CMAKE_COMPILER_IS_GNUCC)
  SET(ALTIVEC_FLAGS "-maltivec")
ENDIF(CMAKE_COMPILER_IS_GNUCC)

SET(CMAKE_REQUIRED_FLAGS "${ALTIVEC_FLAGS}")
CHECK_C_SOURCE_COMPILES(
"#include <altivec.h>
int main() {
vector unsigned char v1, v2, v3;
v1 = vec_add(v2, v3);
}
" HAVE_ALTIVEC)
SET(CMAKE_REQUIRED_FLAGS "")
ENDMACRO(CHECK_ALTIVEC)
