#ifndef VOICEDATA_H
#define VOICEDATA_H

#include <stdio.h>
#include <stdlib.h>
#include <QtCore/QObject>
#include <QtCore/QString>

#define MAX_PARAMS 10
#define MAX_SPLIT 9
#define MAX_SCENES 2
#define MAX_SOURCES 4
#define MAX_HARMONIC_GROUPS 8
#define MAX_OSC 5
#define MAX_SCALES 80
#define MAX_POLY 128
#define STEP 64
#define FILTER_LEN 24
#define MAX_LEVEL 2147483647

typedef struct voiceType {
  int note;    
  int velocity;
  bool gate, active, sustain;
  long samples, filterMixSampleStack[MAX_SOURCES];
  double filterMixEnv[MAX_SOURCES];
  int filterMixEnvState[MAX_SOURCES];
  double filterModEnv[2];
  int filterModEnvState[2];
  double filterModLfo[2], filterModSpacingLfo[2];
  int filterModLfoState[2], filterModSpacingLfoState[2];
  double cut;
} voiceType;

typedef struct envelopeType {
  double val, lfo;
  int state, lfo_state;
  double y, dy, ddy, a, freqSh;
} envelopeType;

typedef struct modulationEnvelope {
  double delay, attack, decay1, decay2, level, release, amount;
  bool inverse;
} modulationEnvelope;

typedef struct modulationLfo {
  double delay, freq, depth;
  bool inverse, fast, retrigger;
} modulationLfo;

class VoiceData : public QObject
{
  private:
    double rnd_scale;
    QString comment;
    voiceType *voice;
    double *harmonics[MAX_PARAMS];
    int hmax[MAX_HARMONIC_GROUPS][MAX_PARAMS];
    double *scaledHarmonics[MAX_PARAMS];
    double scaleLin[MAX_PARAMS];
    double scaleExp[MAX_PARAMS];
    double minScale[MAX_PARAMS];
    double maxScale[MAX_PARAMS];
    double scale[MAX_SCALES];
    double filter[2][FILTER_LEN];
    double filterCutoff[2], filterSpacing[2], filterKeyTracking[2], filterDepth[2];
    double filterMixMorph[MAX_SOURCES], filterMixMode[MAX_SOURCES], filterMixEnvAmount[MAX_SOURCES];
    double filterMixDelay[MAX_SOURCES], filterMixAttack[MAX_SOURCES], filterMixDecay[MAX_SOURCES];
    bool filterMixLfo[MAX_SOURCES], filterMixRetrigger[MAX_SOURCES], filterMixHold[MAX_SOURCES];
    modulationEnvelope filterModEnvelope[2];
    modulationLfo filterModLfo[2], filterModSpacingLfo[2];
    double masterVolume, pitchBend, lfo, dlfo, lfoFreq, lfoDepth;
    double detune, offsetDetune, voiceRandom, currentVoiceDetune;
    double volumeTracking, velocityDepth;
    double delta[6];
    double evenOdd[4];
    double noiseBandwidth;
    bool noiseSubHarmonicMode;
    int noiseFreqDiffusion;
    int osc3Mode;
    int osc3FreqDiffusion;
    double morphing;
    double linearLevel, transitionWidth, compression, antialiasing;
    double panCenter, panWidth;
    int panMode;
    int lfoState;
    int rate, bufSize;
    envelopeType *envelopes;
    bool synthesisFlag;
    int numHarmonics;
    int harmonicSplit[MAX_SPLIT];
    int channel;
    QString fileName;
    int editStart, editEnd;
    
  public:
    VoiceData(QObject* parent=0);
    ~VoiceData();

    void setComment(QString qs);
    QString getComment();
    void setEditRange(int start, int end);
    void getEditRange(int& start, int& end); 
    void setRate(int p_rate);
    void setChannel(int value);
    int getChannel();
    void setFileName(QString name);
    QString getFileName();
    double getPitchBend(); 
    void setPitchBend(double p_pitchBend); 
    double getLFO(); 
    void lfoStep(); 
    void setMasterVolume(double value);
    double getMasterVolume();
    double getMinScale(int p_index); 
    double getMaxScale(int p_index); 
    void setGroupScale(int p_group, int p_index, int value); 
    bool doSynthesis(); 
    voiceType* getVoice();
    void setVoice(voiceType* p_voice);
    envelopeType* getEnvelopes(); 
    int getNumHarmonics(); 
    void setNumHarmonics(int p_numHarmonics); 
    int calcEditGroup(int p_index);
    double *getHarmonics(int p_index); 
    double getHarmonic(int p_index, int p_num); 
    double getScaledHarmonic(int p_index, int p_num); 
    void setHarmonic(int p_index, int p_num, double p_value); 
    double *getFilter(int p_index);
    double getFilter(int p_index, int p_num);
    void setFilter(int p_index, int p_num, double p_value);
    double getFilterCutoff(int p_index);
    double getFilterSpacing(int p_index);
    double getFilterKeyTracking(int p_index); 
    double getFilterDepth(int p_index);
    void setFilterCutoff(int p_index, double p_value);
    void setFilterSpacing(int p_index, double p_value);
    void setFilterKeyTracking(int p_index, double p_value); 
    void setFilterDepth(int p_index, double p_value);
    void setLfoFreq(double value); 
    double getLfoFreq(); 
    void setLfoDepth(double value); 
    double getLfoDepth(); 
    void resetLFO(); 
    double getMorphing(); 
    void setMorphing(double value); 
    void setCompressor(int index, double value);
    void getCompressorCoeff(double& x0, double& x1, double& a, double& b, double& c, double& d, double& aa);
    void setPan(int index, double value);
    void getPan(double& p_panCenter, double& p_panWidth, int& p_panMode); 
    double getDelta(int index); 
    void setDelta(int index, double value);
    void setEvenOdd(int index, double value);
    double getEvenOdd(int index);
    void setNoiseBandwidth(double value);
    double getNoiseBandwidth();
    void setNoiseFreqDiffusion(int value);
    int getNoiseFreqDiffusion();
    void setNoiseSubHarmonicMode(bool on);
    bool getNoiseSubHarmonicMode();
    void setOsc3Mode(int value);
    int getOsc3Mode();
    void setOsc3FreqDiffusion(int value);
    int getOsc3FreqDiffusion();
    void setFilterMixMorph(int spectrumIndex, double value);
    void setFilterMixMode(int spectrumIndex, double value);
    void setFilterMixEnvAmount(int spectrumIndex, double value);
    void setFilterMixDelay(int spectrumIndex, double value);
    void setFilterMixAttack(int spectrumIndex, double value);
    void setFilterMixDecay(int spectrumIndex, double value);
    void setFilterMixLfo(int spectrumIndex, bool on);
    void setFilterMixRetrigger(int spectrumIndex, bool on);
    void setFilterMixHold(int spectrumIndex, bool on);
    double getFilterMixMorph(int spectrumIndex);
    double getFilterMixMode(int spectrumIndex);
    double getFilterMixEnvAmount(int spectrumIndex);
    double getFilterMixDelay(int spectrumIndex);
    double getFilterMixAttack(int spectrumIndex);
    double getFilterMixDecay(int spectrumIndex);
    bool getFilterMixLfo(int spectrumIndex);
    bool getFilterMixRetrigger(int spectrumIndex);
    bool getFilterMixHold(int spectrumIndex);
    void setFilterModEnvelope(int filterIndex, modulationEnvelope p_Envelope);
    void setFilterModLfo(int filterIndex, modulationLfo p_Lfo);
    void setFilterModSpacingLfo(int filterIndex, modulationLfo p_Lfo);
    modulationEnvelope getFilterModEnvelope(int filterIndex);
    modulationLfo getFilterModLfo(int filterIndex);
    modulationLfo getFilterModSpacingLfo(int filterIndex);
    int getMaxHarmonic(int p_index);
    int getHMax(int p_index, int p_num);
    void setDetune(double value);
    double getDetune();
    void setOffsetDetune(double value);
    double getOffsetDetune();
    void setVoiceRandom(double value);
    double getVoiceRandom();
    void newCurrentVoiceDetune();
    double getCurrentVoiceDetune();
    void setVolumeTracking(double value);
    double getVolumeTracking();
    void setVelocityDepth(double value);
    double getVelocityDepth();
};
  
#endif
