/******************************************************************************
 *
 * Module Name: dttemplate.h - ACPI table template definitions
 *
 *****************************************************************************/

/*
 * Copyright (C) 2000 - 2023, Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 */

#ifndef __DTTEMPLATE_H
#define __DTTEMPLATE_H


/* Templates for ACPI data tables */

const unsigned char TemplateAest[] =
{
    0x41,0x45,0x53,0x54,0xCC,0x02,0x00,0x00,  /* 00000000    "AEST...." */
    0x01,0x2A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".*INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x04,0x06,0x21,0x20,0x00,0x80,0x00,0x00,  /* 00000020    "..! ...." */
    0x2C,0x00,0x00,0x00,0x44,0x00,0x00,0x00,  /* 00000028    ",...D..." */
    0x74,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "t......." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000038    "....gE#." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0xCD,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000058    "....gE#." */
    0x33,0x33,0x22,0x22,0x00,0x00,0x00,0x00,  /* 00000060    "33""...." */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000068    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000070    "....gE#." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000078    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x11,0x11,0x11,0x01,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x01,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x78,  /* 00000098    ".......x" */
    0x56,0x00,0x00,0x00,0x00,0x74,0x00,0x00,  /* 000000A0    "V....t.." */
    0x2C,0x00,0x00,0x00,0x44,0x00,0x00,0x00,  /* 000000A8    ",...D..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000000B8    "....gE#." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x11,0x11,0x00,0x00,0x01,0x00,0x01,0x00,  /* 000000D0    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000000D8    "....gE#." */
    0x67,0x67,0x67,0x67,0x00,0x00,0x00,0x00,  /* 000000E0    "gggg...." */
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000E8    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000000F0    "....gE#." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x11,0x11,0x11,0x01,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x01,0x60,0x00,0x00,0x2C,0x00,0x00,0x00,  /* 00000118    ".`..,..." */
    0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "0......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x00,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 00000138    "........" */
    0x67,0x45,0x23,0x01,0xAA,0xAA,0x00,0x00,  /* 00000140    "gE#....." */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000148    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000150    "....gE#." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000158    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000168    "........" */
    0x11,0x11,0x11,0x01,0x00,0x00,0x00,0x00,  /* 00000170    "........" */
    0x02,0x64,0x00,0x00,0x2C,0x00,0x00,0x00,  /* 00000178    ".d..,..." */
    0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "4......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000188    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000190    "........" */
    0x00,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 00000198    "........" */
    0x67,0x45,0x23,0x01,0x55,0x55,0x55,0x55,  /* 000001A0    "gE#.UUUU" */
    0x66,0x66,0x66,0x66,0x01,0x00,0x00,0x00,  /* 000001A8    "ffff...." */
    0x03,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 000001B0    "........" */
    0x67,0x45,0x23,0x01,0x00,0x00,0x00,0x00,  /* 000001B8    "gE#....." */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000001C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C8    "........" */
    0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x01,  /* 000001D0    "........" */
    0x00,0x00,0x00,0x00,0x03,0x74,0x00,0x00,  /* 000001D8    ".....t.." */
    0x2C,0x00,0x00,0x00,0x44,0x00,0x00,0x00,  /* 000001E0    ",...D..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000200    "....gE#." */
    0x33,0x33,0x33,0x33,0x44,0x44,0x44,0x44,  /* 00000208    "3333DDDD" */
    0x12,0x23,0x34,0x45,0x56,0x67,0x78,0x89,  /* 00000210    ".#4EVgx." */
    0x9A,0xAB,0xBC,0xCD,0xDE,0xEF,0xFF,0x55,  /* 00000218    ".......U" */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000220    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000228    "....gE#." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000230    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000238    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000240    "........" */
    0x11,0x11,0x11,0x01,0x00,0x00,0x00,0x00,  /* 00000248    "........" */
    0x04,0x7C,0x00,0x00,0x2C,0x00,0x00,0x00,  /* 00000250    ".|..,..." */
    0x34,0x00,0x00,0x00,0x64,0x00,0x00,0x00,  /* 00000258    "4...d..." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000260    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000268    "........" */
    0x00,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 00000270    "........" */
    0x67,0x45,0x23,0x01,0x03,0x00,0x00,0x00,  /* 00000278    "gE#....." */
    0x88,0x88,0x77,0x77,0x00,0x00,0x00,0x00,  /* 00000280    "..ww...." */
    0x03,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 00000288    "........" */
    0x67,0x45,0x23,0x01,0x00,0x00,0x00,0x00,  /* 00000290    "gE#....." */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000298    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000002A0    "........" */
    0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x01,  /* 000002A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000002B0    "........" */
    0xBB,0xBB,0xAA,0xAA,0xCC,0x00,0x00,0x00,  /* 000002B8    "........" */
    0x01,0x00,0x00,0x01,0xEF,0xCD,0xAB,0x78,  /* 000002C0    ".......x" */
    0x56,0x00,0x00,0x00                       /* 000002C8    "V..."     */
};

const unsigned char TemplateAgdi[] =
{
    0x41,0x47,0x44,0x49,0x30,0x00,0x00,0x00,  /* 00000000    "AGDI0..." */
    0x01,0xE4,0x41,0x4D,0x50,0x45,0x52,0x45,  /* 00000008    "..AMPERE" */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x05,0x01,0x21,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "..! ...." */
    0x01,0x00,0x00,0x40,0x00,0x00,0x00,0x00   /* 00000028    "...@...." */
};

const unsigned char TemplateApmt[] =
{
    0x41,0x50,0x4D,0x54,0x94,0x00,0x00,0x00,  /* 00000000    "APMT...." */
    0x00,0x79,0x4E,0x56,0x49,0x44,0x49,0x41,  /* 00000008    ".yNVIDIA" */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x12,0x21,0x20,0x38,0x00,0x04,0x03,  /* 00000020    "..! 8..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    ". ......" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    ". ......" */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x6B,0x03,0x00,0x00,0x38,0x00,0x06,0x03,  /* 00000058    "k...8..." */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    ".0......" */
    0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    ".0......" */
    0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000088    "........" */
    0x6B,0x03,0x00,0x00                       /* 00000090    "k..."     */
};

const unsigned char TemplateAsf[] =
{
    0x41,0x53,0x46,0x21,0x72,0x00,0x00,0x00,  /* 00000000    "ASF!r..." */
    0x10,0x0B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x10,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x14,0x00,  /* 00000030    "........" */
    0x00,0x00,0x01,0x0C,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x02,0x00,0x0C,0x00,0x01,0x04,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x03,0x00,0x17,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x84,0x00,0x07,0x00,0x00,  /* 00000068    "........" */
    0x01,0x00                                 /* 00000070    ".."       */
};

const unsigned char TemplateAspt[] =
{
    0x41,0x53,0x50,0x54,0x88,0x00,0x00,0x00,  /* 00000000    "ASPT...." */
    0x01,0x2D,0x56,0x52,0x54,0x55,0x41,0x4C,  /* 00000008    "..VRTUAL" */
    0x4D,0x49,0x43,0x52,0x4F,0x53,0x46,0x54,  /* 00000010    "MICROSFT" */
    0x01,0x00,0x00,0x00,0x4D,0x53,0x46,0x54,  /* 00000018    "....INTL" */
    0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000020    " ." ...." */
    0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000028    ".. ....." */
    0x00,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x04,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x08,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x01,0x00,0x20,0x00,0x01,0x00,0x00,0x00,  /* 00000048    ".. ....." */
    0x10,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x14,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x18,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x02,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000068    ".. ....." */
    0x20,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000070    " ......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
};

const unsigned char TemplateBdat[] =
{
    0x42,0x44,0x41,0x54,0x30,0x00,0x00,0x00,  /* 00000000    "BDAT0..." */
    0x01,0xED,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x21,0x20,0x01,0x08,0x00,0x01,  /* 00000020    "1.! ...." */
    0xF0,0xDE,0xBC,0x9A,0x78,0x56,0x34,0x12   /* 00000028    "....xV4." */
};

const unsigned char TemplateBgrt[] =
{
    0x42,0x47,0x52,0x54,0x38,0x00,0x00,0x00,  /* 00000000    "BGRT8..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x23,0x06,0x11,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "#.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000030    "........" */
};

const unsigned char TemplateBert[] =
{
    0x42,0x45,0x52,0x54,0x30,0x00,0x00,0x00,  /* 00000000    "BERT0..." */
    0x01,0x15,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000028    "........" */
};

const unsigned char TemplateBoot[] =
{
    0x42,0x4F,0x4F,0x54,0x28,0x00,0x00,0x00,  /* 00000000    "BOOT(..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x04,0x06,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00   /* 00000020    "(.. ...." */
};

const unsigned char TemplateCcel[] =
{
    0x43,0x43,0x45,0x4C,0x38,0x00,0x00,0x00,  /* 00000000    "CCEL8..." */
    0x04,0x1C,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x30,0x09,0x21,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "0.! ...." */
    0xEF,0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,  /* 00000028    "...xV4.." */
    0x78,0x56,0x34,0x12,0xEF,0xCD,0xAB,0x00   /* 00000030    "xV4....." */
};

const unsigned char TemplateCedt[] =
{
    0x43,0x45,0x44,0x54,0x9c,0x01,0x00,0x00,  /* 00000000    "CEDT...." */
    0x01,0x87,0x49,0x4e,0x54,0x45,0x4c,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4d,0x50,0x4c,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4e,0x54,0x4c,  /* 00000018    "....INTL" */
    0x17,0x12,0x21,0x20,0x00,0x00,0x20,0x00,  /* 00000020    "..! .. ." */
    0x00,0x5e,0xba,0x00,0x00,0x00,0x00,0x00,  /* 00000028    ".^......" */
    0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000038    "..... .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,  /* 00000040    "...... ." */
    0x01,0x5e,0xba,0x00,0x00,0x00,0x00,0x00,  /* 00000048    ".^......" */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000050    "..... .." */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000058    "..... .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,  /* 00000060    "...... ." */
    0x02,0x5e,0xba,0x00,0x00,0x00,0x00,0x00,  /* 00000068    ".^......" */
    0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,  /* 00000070    ".....0.." */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000078    "..... .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,  /* 00000080    "...... ." */
    0x03,0x5e,0xba,0x00,0x00,0x00,0x00,0x00,  /* 00000088    ".^......" */
    0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,  /* 00000090    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000098    "..... .." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x28,0x00,  /* 000000a0    "......(." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000a8    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000b0    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000b8    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 000000c0    "........" */
    0x00,0x5e,0xba,0x00,0x01,0x00,0x28,0x00,  /* 000000c8    ".^....(." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000d0    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000d8    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000e0    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 000000e8    "........" */
    0x01,0x5e,0xba,0x00,0x01,0x00,0x28,0x00,  /* 000000f0    ".^....(." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000f8    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 00000110    "........" */
    0x02,0x5e,0xba,0x00,0x01,0x00,0x28,0x00,  /* 00000118    ".^....(." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 00000138    "........" */
    0x03,0x5e,0xba,0x00,0x01,0x00,0x2c,0x00,  /* 00000140    ".^....,." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000158    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 00000160    "........" */
    0x00,0x5e,0xba,0x00,0x01,0x5e,0xba,0x00,  /* 00000160    ".^...^.." */
    0x01,0x00,0x2c,0x00,0x00,0x00,0x00,0x00,  /* 00000170    "..,....." */
    0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,  /* 00000180    "........" */
    0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000188    "........" */
    0x0a,0x00,0x01,0x00,0x02,0x5e,0xba,0x00,  /* 00000190    ".....^.." */
    0x03,0x5e,0xba,0x00                       /* 00000198    ".^.."     */
};

const unsigned char TemplateCdat[] =
{
    0xE4,0x00,0x00,0x00,0x01,0x0C,0x00,0x00,  /* 00000000    "........" */
    0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,  /* 00000008    "........" */
    0x03,0x00,0x08,0x00,0x04,0x56,0x00,0x00,  /* 00000010    ".....V.." */
    0x00,0x00,0x18,0x00,0xEF,0x01,0x00,0x00,  /* 00000018    "........" */
    0x89,0x67,0x45,0x23,0x01,0x00,0x00,0x00,  /* 00000020    ".gE#...." */
    0xAB,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x03,0x00,0x08,0x00,0x04,0x56,0x00,0x00,  /* 00000030    ".....V.." */
    0x01,0x00,0x18,0x00,0x44,0x04,0x64,0x00,  /* 00000038    "....D.d." */
    0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,0x00,  /* 00000040    "...gE#.." */
    0x33,0x22,0x44,0x33,0x55,0x44,0x00,0x00,  /* 00000048    "3"D3UD.." */
    0x02,0x00,0x14,0x00,0x99,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x78,0x56,0x34,0x12,  /* 00000058    "....xV4." */
    0x55,0x55,0x44,0x44,0x04,0x00,0x18,0x00,  /* 00000060    "UUDD...." */
    0x88,0x32,0x00,0x00,0x77,0x77,0x77,0x77,  /* 00000068    ".2..wwww" */
    0x11,0x11,0x11,0x11,0x88,0x88,0x88,0x88,  /* 00000070    "........" */
    0x22,0x22,0x22,0x22,0x05,0x00,0x20,0x00,  /* 00000078    """"".. ." */
    0x04,0x00,0x00,0x00,0x44,0x44,0x44,0x44,  /* 00000080    "....DDDD" */
    0x33,0x33,0x33,0x33,0x44,0x44,0x55,0x55,  /* 00000088    "3333DDUU" */
    0x66,0x66,0x00,0x00,0x77,0x77,0x88,0x88,  /* 00000090    "ff..ww.." */
    0x99,0x99,0x00,0x00,0x05,0x00,0x18,0x00,  /* 00000098    "........" */
    0x04,0x00,0x00,0x00,0x22,0x22,0x22,0x22,  /* 000000A0    "....""""" */
    0x11,0x11,0x11,0x11,0x34,0x12,0x56,0x78,  /* 000000A8    "....4.Vx" */
    0x11,0x11,0x00,0x00,0x05,0x00,0x30,0x00,  /* 000000B0    "......0." */
    0x08,0x00,0x00,0x00,0x66,0x66,0x66,0x66,  /* 000000B8    "....ffff" */
    0x55,0x55,0x55,0x55,0x44,0x44,0x55,0x55,  /* 000000C0    "UUUUDDUU" */
    0x66,0x66,0x00,0x00,0x77,0x77,0x88,0x88,  /* 000000C8    "ff..ww.." */
    0x99,0x99,0x00,0x00,0xAA,0xAA,0xBB,0xBB,  /* 000000D0    "........" */
    0xCC,0xCC,0x00,0x00,0x55,0x55,0x44,0x44,  /* 000000D8    "....UUDD" */
    0x33,0x33,0x00,0x00                       /* 000000E0    "33.."     */
};

const unsigned char TemplateCpep[] =
{
    0x43,0x50,0x45,0x50,0x34,0x00,0x00,0x00,  /* 00000000    "CPEP4..." */
    0x01,0x0F,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateCsrt[] =
{
    0x43,0x53,0x52,0x54,0x4C,0x01,0x00,0x00,  /* 00000000    "CSRTL..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x14,0x11,0x12,0x20,0x88,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x49,0x4E,0x54,0x4C,0x00,0x00,0x00,0x00,  /* 00000028    "INTL...." */
    0x60,0x9C,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000030    "`......." */
    0x1C,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0xA0,0xB3,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x2A,0x00,0x00,0x00,0x02,0x00,0x06,0x20,  /* 00000048    "*...... " */
    0x00,0x00,0x10,0x00,0xFF,0x0F,0x00,0x00,  /* 00000050    "........" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x01,0x00,  /* 00000058    "........" */
    0x53,0x50,0x49,0x20,0x0C,0x00,0x00,0x00,  /* 00000060    "SPI ...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x30,  /* 00000068    "....CHA0" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000070    "........" */
    0x43,0x48,0x41,0x31,0x0C,0x00,0x00,0x00,  /* 00000078    "CHA1...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x32,  /* 00000080    "....CHA2" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000088    "........" */
    0x43,0x48,0x41,0x33,0x0C,0x00,0x00,0x00,  /* 00000090    "CHA3...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x34,  /* 00000098    "....CHA4" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x43,0x48,0x41,0x35,0xA0,0x00,0x00,0x00,  /* 000000A8    "CHA5...." */
    0x49,0x4E,0x54,0x4C,0x00,0x00,0x00,0x00,  /* 000000B0    "INTL...." */
    0x60,0x9C,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000B8    "`......." */
    0x1C,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x2B,0x00,0x00,0x00,0x02,0x00,0x08,0x20,  /* 000000D0    "+...... " */
    0x10,0x00,0x10,0x00,0xFF,0x0F,0x00,0x00,  /* 000000D8    "........" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x01,0x00,  /* 000000E0    "........" */
    0x49,0x32,0x43,0x20,0x0C,0x00,0x00,0x00,  /* 000000E8    "I2C ...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x30,  /* 000000F0    "....CHA0" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x43,0x48,0x41,0x31,0x0C,0x00,0x00,0x00,  /* 00000100    "CHA1...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x32,  /* 00000108    "....CHA2" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000110    "........" */
    0x43,0x48,0x41,0x33,0x0C,0x00,0x00,0x00,  /* 00000118    "CHA3...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x34,  /* 00000120    "....CHA4" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000128    "........" */
    0x43,0x48,0x41,0x35,0x0C,0x00,0x00,0x00,  /* 00000130    "CHA5...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x36,  /* 00000138    "....CHA6" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000140    "........" */
    0x43,0x48,0x41,0x37                       /* 00000148    "CHA7"     */
};

const unsigned char TemplateDbg2[] =
{
    0x44,0x42,0x47,0x32,0xB2,0x00,0x00,0x00,  /* 00000000    "DBG2...." */
    0x01,0xBA,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x15,0x11,0x13,0x20,0x2C,0x00,0x00,0x00,  /* 00000020    "... ,..." */
    0x02,0x00,0x00,0x00,0xEE,0x3F,0x00,0x02,  /* 00000028    ".....?.." */
    0x09,0x00,0x36,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "..6....." */
    0x00,0x80,0x00,0x00,0x00,0x00,0x16,0x00,  /* 00000038    "........" */
    0x2E,0x00,0x01,0x32,0x00,0x03,0x88,0x77,  /* 00000040    "...2...w" */
    0x66,0x55,0x44,0x33,0x22,0x11,0x01,0x64,  /* 00000048    "fUD3"..d" */
    0x00,0x04,0x11,0x00,0xFF,0xEE,0xDD,0xCC,  /* 00000050    "........" */
    0xBB,0xAA,0x10,0x32,0x54,0x76,0x98,0xBA,  /* 00000058    "...2Tv.." */
    0xDC,0xFE,0x4D,0x79,0x44,0x65,0x76,0x69,  /* 00000060    "..MyDevi" */
    0x63,0x65,0x00,0xEE,0x47,0x00,0x01,0x11,  /* 00000068    "ce..G..." */
    0x00,0x26,0x00,0x10,0x00,0x37,0x00,0x00,  /* 00000070    ".&...7.." */
    0x80,0x00,0x00,0x00,0x00,0x16,0x00,0x22,  /* 00000078    "......."" */
    0x00,0x01,0x64,0x00,0x04,0x11,0x00,0xFF,  /* 00000080    "..d....." */
    0xEE,0xDD,0xCC,0xBB,0xAA,0x98,0xBA,0xDC,  /* 00000088    "........" */
    0xFE,0x5C,0x5C,0x5F,0x53,0x42,0x5F,0x2E,  /* 00000090    ".\\_SB_." */
    0x50,0x43,0x49,0x30,0x2E,0x44,0x42,0x47,  /* 00000098    "PCI0.DBG" */
    0x50,0x00,0x41,0x42,0x43,0x44,0x45,0x46,  /* 000000A0    "P.ABCDEF" */
    0x47,0x48,0x49,0x50,0x51,0x52,0x53,0x54,  /* 000000A8    "GHIPQRST" */
    0x55,0x56                                 /* 000000B0    "UV"       */
};

const unsigned char TemplateDbgp[] =
{
    0x44,0x42,0x47,0x50,0x34,0x00,0x00,0x00,  /* 00000000    "DBGP4..." */
    0x01,0x1A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateDmar[] =
{
    0x44,0x4D,0x41,0x52,0x9C,0x00,0x00,0x00,  /* 00000000    "DMAR...." */
    0x01,0xB8,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x12,0x21,0x20,0x2F,0x01,0x00,0x00,  /* 00000020    "..! /..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x18,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x03,0x08,0x00,0x00,0x08,0x00,0x00,0x01,  /* 00000040    "........" */
    0x01,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000048    ".. ....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x02,  /* 00000060    "........" */
    0x02,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x02,0x08,0x00,0x00,0x00,0x00,0x00,0x03,  /* 00000070    "........" */
    0x03,0x00,0x14,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x05,0x00,0x10,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x02                       /* 00000098    "...."     */
};

const unsigned char TemplateDrtm[] =
{
    0x44,0x52,0x54,0x4D,0x94,0x00,0x00,0x00,  /* 00000000    "DRTM...." */
    0x01,0xB9,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00                       /* 00000090    "...."     */
};

const unsigned char TemplateEcdt[] =
{
    0x45,0x43,0x44,0x54,0x42,0x00,0x00,0x00,  /* 00000000    "ECDTB..." */
    0x01,0x2D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".-INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x01,0x08,0x00,0x00,  /* 00000020    "(.. ...." */
    0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "f......." */
    0x01,0x08,0x00,0x00,0x62,0x00,0x00,0x00,  /* 00000030    "....b..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x09,0x00                                 /* 00000040    ".."       */
};

const unsigned char TemplateEinj[] =
{
    0x45,0x49,0x4E,0x4A,0x30,0x01,0x00,0x00,  /* 00000000    "EINJ0..." */
    0x01,0x09,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x30,0x00,0x00,0x00,  /* 00000020    "(.. 0..." */
    0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000030    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000050    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000068    "........" */
    0x02,0x02,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000070    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000088    "........" */
    0x03,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000090    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000A8    "........" */
    0x04,0x03,0x01,0x00,0x00,0x40,0x00,0x04,  /* 000000B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000C8    "........" */
    0x05,0x03,0x01,0x00,0x01,0x10,0x00,0x02,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000E8    "........" */
    0x06,0x01,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000108    "........" */
    0x07,0x00,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000110    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF   /* 00000128    "........" */
};

const unsigned char TemplateErst[] =
{
    0x45,0x52,0x53,0x54,0x30,0x02,0x00,0x00,  /* 00000000    "ERST0..." */
    0x01,0xAB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x30,0x00,0x00,0x00,  /* 00000020    "(.. 0..." */
    0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000030    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000048    "........" */
    0x01,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000050    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000068    "........" */
    0x02,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000070    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000088    "........" */
    0x03,0x04,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000090    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000A8    "........" */
    0x04,0x02,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000C8    "........" */
    0x05,0x03,0x00,0x00,0x01,0x08,0x00,0x01,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000E8    "........" */
    0x06,0x01,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000108    "........" */
    0x07,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000110    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000128    "........" */
    0x08,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000130    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000148    "........" */
    0x09,0x02,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000150    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000168    "........" */
    0x0A,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000170    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000188    "........" */
    0x0B,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000190    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000198    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001A8    "........" */
    0x0C,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001C8    "........" */
    0x0D,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001D0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001E8    "........" */
    0x0E,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000208    "........" */
    0x0F,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000210    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000218    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF   /* 00000228    "........" */
};

const unsigned char TemplateFacs[] =
{
    0x46,0x41,0x43,0x53,0x40,0x00,0x00,0x00,  /* 00000000    "FACS@..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000008    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000010    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000020    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000038    "........" */
};

/* Version 5 FADT */

const unsigned char TemplateFadt[] =
{
    0x46,0x41,0x43,0x50,0x14,0x01,0x00,0x00,  /* 00000000    "FACP...." */
    0x06,0x8A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x04,0x02,0x01,0x04,0x08,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 00000070    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x02,  /* 00000090    "..... .." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x01,0x10,0x00,0x02,  /* 000000A8    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x00,  /* 000000C0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x01,0x20,0x00,0x03,0x01,0x00,0x00,0x00,  /* 000000D0    ". ......" */
    0x00,0x00,0x00,0x00,0x01,0x40,0x00,0x01,  /* 000000D8    ".....@.." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x01,0x08,0x00,0x01,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00                       /* 00000110    "...."     */
};

const unsigned char TemplateFpdt[] =
{
    0x46,0x50,0x44,0x54,0x64,0x00,0x00,0x00,  /* 00000000    "FPDTd..." */
    0x01,0xBD,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x04,0x08,0x11,0x20,0x00,0x00,0x30,0x01,  /* 00000020    "... ..0." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x10,0x01,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00                       /* 00000060    "...."     */
};

const unsigned char TemplateGtdt[] =
{
    0x47,0x54,0x44,0x54,0xE8,0x00,0x00,0x00,  /* 00000000    "GTDT...." */
    0x03,0x5D,0x4C,0x49,0x4E,0x41,0x52,0x4F,  /* 00000008    ".]LINARO" */
    0x52,0x54,0x53,0x4D,0x56,0x45,0x56,0x38,  /* 00000010    "RTSMVEV8" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x08,0x01,0x19,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x1D,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x1E,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000038    "........" */
    0x1B,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000040    "........" */
    0x1A,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x02,0x00,0x00,0x00,0x60,0x00,0x00,0x00,  /* 00000058    "....`..." */
    0x43,0x00,0x00,0x00,0x21,0x00,0x00,0x00,  /* 00000060    "C...!..." */
    0x00,0x64,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    ".d......" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000070    "........" */
    0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x01,0x1C,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00   /* 000000E0    "........" */
};

const unsigned char TemplateHest[] =
{
    0x48,0x45,0x53,0x54,0x7C,0x02,0x00,0x00,  /* 00000000    "HEST|..." */
    0x01,0x97,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x03,0x03,0x17,0x20,0x04,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,  /* 00000028    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x01,  /* 00000088    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x01,  /* 000000F0    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000120    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x09,0x00,0x02,0x00,  /* 00000150    "........" */
    0xFF,0xFF,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000158    "........" */
    0x01,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 00000160    "........" */
    0x00,0x40,0x00,0x04,0x00,0x00,0x00,0x00,  /* 00000168    ".@......" */
    0x00,0x00,0x00,0x00,0x03,0x1C,0x00,0x00,  /* 00000170    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000188    "........" */
    0x00,0x10,0x00,0x00,0x09,0x00,0x03,0x00,  /* 00000190    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000198    "........" */
    0x01,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 000001A0    "........" */
    0x00,0x40,0x00,0x04,0x00,0x00,0x00,0x00,  /* 000001A8    ".@......" */
    0x00,0x00,0x00,0x00,0x04,0x1C,0x00,0x00,  /* 000001B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C8    "........" */
    0x00,0x10,0x00,0x00,0x0A,0x00,0x03,0x00,  /* 000001D0    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x01,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 000001E0    "........" */
    0x00,0x40,0x00,0x04,0x00,0x00,0x00,0x00,  /* 000001E8    ".@......" */
    0x00,0x00,0x00,0x00,0x04,0x1C,0x00,0x00,  /* 000001F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000208    "........" */
    0x00,0x10,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000210    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000218    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "........" */
    0x0B,0x00,0x01,0x00,0x00,0x00,0x00,0x01,  /* 00000230    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000238    "........" */
    0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000240    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000248    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000250    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000258    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000260    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000268    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000270    "........" */
    0x00,0x00,0x00,0x00                       /* 00000278    "...."     */
};

const unsigned char TemplateHmat[] =
{
    0x48,0x4D,0x41,0x54,0x9C,0x00,0x00,0x00,  /* 00000000    "HMAT...." */
    0x02,0x4D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".MINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x08,0x01,0x19,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x28,0x00,0x00,0x00,  /* 00000028    "....(..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x2A,0x00,0x00,0x00,  /* 00000050    "....*..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x02,0x00,0x00,0x00,0x22,0x00,  /* 00000078    "......"." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x01,0x00,0x00,0x00                       /* 00000098    "...."     */
};

const unsigned char TemplateHpet[] =
{
    0x48,0x50,0x45,0x54,0x38,0x00,0x00,0x00,  /* 00000000    "HPET8..." */
    0x01,0x09,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000030    "........" */
};

const unsigned char TemplateIort[] =
{
    0x49,0x4F,0x52,0x54,0x3C,0x02,0x00,0x00,  /* 00000000    "IORT<..." */
    0x05,0xCB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x12,0x21,0x20,0x07,0x00,0x00,0x00,  /* 00000020    "..! ...." */
    0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "4......." */
    0x49,0x4F,0x52,0x54,0x00,0x18,0x00,0x01,  /* 00000030    "IORT...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x01,0x80,0x00,0x04,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000050    "........" */
    0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "l......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x5C,0x5F,0x53,0x42,0x2E,0x50,0x43,  /* 00000068    ".\_SB.PC" */
    0x49,0x30,0x2E,0x44,0x45,0x56,0x30,0x00,  /* 00000070    "I0.DEV0." */
    0x49,0x4F,0x52,0x54,0x3C,0x02,0x00,0x00,  /* 00000078    "IORT<..." */
    0x03,0xF1,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000080    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000088    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000090    "....INTL" */
    0x05,0x01,0x21,0x20,0x07,0x00,0x00,0x00,  /* 00000098    "..! ...." */
    0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "4......." */
    0x49,0x4F,0x52,0x54,0x00,0x18,0x00,0x01,  /* 000000A8    "IORT...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x02,0x38,0x00,0x04,  /* 000000C8    ".....8.." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "$......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x03,0x60,0x00,0x03,  /* 00000100    ".....`.." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000108    "........" */
    0x4C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "L......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,  /* 00000128    "....<..." */
    0x00,0x00,0x00,0x00,0x4C,0x00,0x00,0x00,  /* 00000130    "....L..." */
    0x00,0x00,0x00,0x00,0x4C,0x00,0x00,0x00,  /* 00000138    "....L..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x04,0x58,0x00,0x04,  /* 00000160    ".....X.." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000168    "........" */
    0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000170    "D......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000188    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000190    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000198    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B0    "........" */
    0x00,0x00,0x00,0x00,0x05,0x3C,0x00,0x02,  /* 000001B8    ".....<.." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000001C0    "........" */
    0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C8    "(......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000001F0    "........" */
    0x06,0x44,0x00,0x03,0x00,0x00,0x00,0x00,  /* 000001F8    ".D......" */
    0x01,0x00,0x00,0x00,0x30,0x00,0x00,0x00,  /* 00000200    "....0..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000208    "........" */
    0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000210    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000218    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000230    "........" */
    0x00,0x00,0x00,0x00                       /* 00000238    "...."     */
};

const unsigned char TemplateIvrs[] =
{
    0x49,0x56,0x52,0x53,0x10,0x02,0x00,0x00,  /* 00000000    "IVRS...." */
    0x02,0x6C,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".lINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x21,0x20,0x41,0x30,0x20,0x00,  /* 00000020    "1.! A0 ." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x10,0xB0,0x64,0x00,0x02,0x00,0x40,0x00,  /* 00000030    "..d...@." */
    0x00,0x00,0xF0,0xFD,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x6F,0x8F,0x04,0x80,  /* 00000040    "....o..." */
    0x03,0x08,0x00,0x00,0x01,0x08,0x00,0x00,  /* 00000048    "........" */
    0x02,0x08,0x00,0x00,0x04,0xFE,0xFF,0x00,  /* 00000050    "........" */
    0x42,0x00,0xFF,0x00,0x00,0xA5,0x00,0x00,  /* 00000058    "B......." */
    0x43,0x00,0xFF,0x00,0x00,0xA5,0x00,0x00,  /* 00000060    "C......." */
    0x46,0x00,0xFF,0x00,0x44,0x33,0x22,0x11,  /* 00000068    "F...D3"." */
    0x47,0x00,0xFF,0x00,0x44,0x33,0x22,0x11,  /* 00000070    "G...D3"." */
    0x04,0xFF,0xFF,0x00,0x48,0x00,0x00,0x00,  /* 00000078    "....H..." */
    0x00,0xA0,0x00,0x02,0x48,0x00,0x00,0xD7,  /* 00000080    "....H..." */
    0x21,0xA0,0x00,0x01,0x48,0x00,0x00,0x00,  /* 00000088    "!...H..." */
    0x22,0x01,0x00,0x01,0x11,0xB0,0x48,0x00,  /* 00000090    "".....H." */
    0x02,0x00,0x40,0x00,0x00,0x00,0xF0,0xFD,  /* 00000098    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x02,0x04,0x00,0xDE,0x4A,0x25,0x22,  /* 000000A8    ".....J%"" */
    0xEF,0x73,0x6D,0x20,0x00,0x00,0x00,0x00,  /* 000000B0    ".sm ...." */
    0x00,0x00,0x00,0x00,0x03,0x08,0x00,0x00,  /* 000000B8    "........" */
    0x04,0xFE,0xFF,0x00,0x43,0x00,0xFF,0x00,  /* 000000C0    "....C..." */
    0x00,0xA5,0x00,0x00,0x04,0xFF,0xFF,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x48,0x00,0x00,0x00,  /* 000000D0    "....H..." */
    0x00,0xA0,0x00,0x02,0x40,0xB0,0xD4,0x00,  /* 000000D8    "....@..." */
    0x02,0x00,0x40,0x00,0x00,0x00,0xF0,0xFD,  /* 000000E0    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x02,0x04,0x00,0xDE,0x4A,0x25,0x22,  /* 000000F0    ".....J%"" */
    0xEF,0x73,0x6D,0x20,0x00,0x00,0x00,0x00,  /* 000000F8    ".sm ...." */
    0x00,0x00,0x00,0x00,0x03,0x08,0x00,0x00,  /* 00000100    "........" */
    0x04,0xFE,0xFF,0x00,0x43,0x00,0xFF,0x00,  /* 00000108    "....C..." */
    0x00,0xA5,0x00,0x00,0x04,0xFF,0xFF,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x48,0x00,0x00,0x00,  /* 00000118    "....H..." */
    0x00,0xA0,0x00,0x02,0x48,0x00,0x00,0xD7,  /* 00000120    "....H..." */
    0x21,0xA0,0x00,0x01,0x48,0x00,0x00,0x00,  /* 00000128    "!...H..." */
    0x22,0x01,0x00,0x01,0xF0,0xA5,0x00,0x40,  /* 00000130    ""......@" */
    0x49,0x4E,0x54,0x43,0x30,0x30,0x32,0x30,  /* 00000138    "INTC0020" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x02,0x09,0x5C,0x5F,0x53,0x42,0x2E,0x44,  /* 00000148    "..\_SB.D" */
    0x45,0x56,0x30,0xF0,0xA5,0x00,0x40,0x49,  /* 00000150    "EV0...@I" */
    0x4E,0x54,0x43,0x30,0x30,0x32,0x30,0x00,  /* 00000158    "NTC0020." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,  /* 00000160    "........" */
    0x09,0x5C,0x5F,0x53,0x42,0x2E,0x44,0x45,  /* 00000168    ".\_SB.DE" */
    0x56,0x31,0xF0,0xA5,0x00,0x40,0x49,0x4E,  /* 00000170    "V1...@IN" */
    0x54,0x43,0x30,0x30,0x32,0x30,0x00,0x00,  /* 00000178    "TC0020.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x09,  /* 00000180    "........" */
    0x5C,0x5F,0x53,0x42,0x2E,0x44,0x45,0x56,  /* 00000188    "\_SB.DEV" */
    0x32,0xF0,0xA5,0x00,0x40,0x49,0x4E,0x54,  /* 00000190    "2...@INT" */
    0x43,0x30,0x30,0x32,0x30,0x00,0x00,0x00,  /* 00000198    "C0020..." */
    0x00,0x00,0x00,0x00,0x00,0x02,0x09,0x5C,  /* 000001A0    ".......\" */
    0x5F,0x53,0x42,0x2E,0x44,0x45,0x56,0x33,  /* 000001A8    "_SB.DEV3" */
    0x20,0x0D,0x20,0x00,0x22,0x11,0x00,0x00,  /* 000001B0    " . ."..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B8    "........" */
    0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,0x00,  /* 000001C0    "..xV4..." */
    0xDC,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C8    "........" */
    0x21,0x0D,0x20,0x00,0x22,0x11,0x00,0x00,  /* 000001D0    "!. ."..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,0x00,  /* 000001E0    "..xV4..." */
    0xDC,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E8    "........" */
    0x22,0x0D,0x20,0x00,0x22,0x11,0x00,0x00,  /* 000001F0    "". ."..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,0x00,  /* 00000200    "..xV4..." */
    0xDC,0xFE,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000208    "........" */
};

const unsigned char TemplateLpit[] =
{
    0x4C,0x50,0x49,0x54,0x94,0x00,0x00,0x00,  /* 00000000    "LPIT...." */
    0x00,0xD8,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "8......." */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x7F,0x40,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    ".@......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "8......." */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x7F,0x40,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    ".@......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00                       /* 00000090    "...."     */
};

/* MADT with ACPI 6.0 subtables */

const unsigned char TemplateMadt[] =
{
    0x41,0x50,0x49,0x43,0x60,0x02,0x00,0x00,  /* 00000000    "APIC...." */
    0x05,0x69,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x22,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "1." ...." */
    0x01,0x00,0x00,0x00,0x00,0x08,0x00,0x00,  /* 00000028    "........" */
    0x01,0x00,0x00,0x00,0x01,0x0C,0x01,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x02,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x03,0x08,0x0D,0x00,0x01,0x00,  /* 00000048    "........" */
    0x00,0x00,0x04,0x06,0x00,0x05,0x00,0x01,  /* 00000050    "........" */
    0x05,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x06,0x10,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x07,0x16,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x5C,0x43,0x50,0x55,  /* 00000080    "....\CPU" */
    0x30,0x00,0x08,0x10,0x05,0x00,0x00,0x00,  /* 00000088    "0......." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,  /* 00000090    "........" */
    0x00,0x00,0x09,0x10,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x0A,0x0C,0x05,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x50,  /* 000000B0    ".......P" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x18,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x0D,0x18,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000128    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x10,  /* 00000130    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x14,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x10,0x10,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0x00,0x00,0x11,0x0F,0x01,0x01,0x00,0x00,  /* 00000168    "........" */
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,  /* 00000170    "........" */
    0x00,0x12,0x17,0x01,0x00,0x14,0xE0,0x1F,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x80,0x00,0x02,0x03,  /* 00000180    "........" */
    0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0xFF,  /* 00000188    "........" */
    0x13,0x15,0x01,0x80,0x00,0x00,0xFB,0xFD,  /* 00000190    "........" */
    0x0E,0x00,0x00,0x40,0x00,0x00,0x00,0x00,  /* 00000198    "...@...." */
    0xFF,0x00,0x00,0x00,0x00,0x14,0x0D,0x01,  /* 000001A0    "........" */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A8    "........" */
    0x00,0x00,0x15,0x13,0x01,0x00,0x00,0xF0,  /* 000001B0    "........" */
    0x2F,0x00,0x00,0x00,0x00,0x40,0x00,0x00,  /* 000001B8    "/....@.." */
    0x00,0xC0,0x00,0x00,0x00,0x16,0x11,0x01,  /* 000001C0    "........" */
    0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,  /* 000001C8    "........" */
    0x00,0x10,0x00,0x00,0x40,0x00,0x17,0x0E,  /* 000001D0    "....@..." */
    0x01,0x00,0x20,0x00,0x10,0x00,0x00,0x00,  /* 000001D8    ".. ....." */
    0x00,0x00,0x10,0x13,0x18,0x24,0x01,0x00,  /* 000001E0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,  /* 000001F8    ".......(" */
    0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 00000200    "........" */
    0x19,0x10,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000208    "........" */
    0xFF,0x00,0xFF,0x00,0x00,0x00,0x00,0x18,  /* 00000210    "........" */
    0x1A,0x24,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000218    ".$......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "..`....." */
    0x00,0x00,0x00,0x0D,0x00,0x00,0x00,0x00,  /* 00000230    "........" */
    0x00,0x80,0x00,0x00,0x1B,0x24,0x01,0x00,  /* 00000238    ".....$.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000240    "........" */
    0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000248    "`.....`." */
    0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x0C,  /* 00000250    "..`....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000258    "........" */
};

const unsigned char TemplateMcfg[] =
{
    0x4D,0x43,0x46,0x47,0x3C,0x00,0x00,0x00,  /* 00000000    "MCFG<..." */
    0x01,0x19,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00                       /* 00000038    "...."     */
};

const unsigned char TemplateMchi[] =
{
    0x4D,0x43,0x48,0x49,0x45,0x00,0x00,0x00,  /* 00000000    "MCHIE..." */
    0x01,0xE4,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x15,0x07,0x00,0x02,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x02,0x08,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00                  /* 00000040    "....."    */
};

const unsigned char TemplateMsdm[] =
{
    0x4D,0x53,0x44,0x4D,0x64,0x00,0x00,0x00,  /* 00000000    "MSDMd..." */
    0x01,0x34,0x49,0x6E,0x74,0x65,0x6C,0x00,  /* 00000008    ".4Intel." */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x03,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x04,0x02,0x15,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x0A,0x10,0x16,0x17,0x18,0x19,0x1A,0x1B,  /* 00000028    "........" */
    0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,  /* 00000030    ".... !"#" */
    0x24,0x25,0x26,0x27,0x10,0x0A,0x15,0x16,  /* 00000038    "$%&'...." */
    0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,  /* 00000040    "........" */
    0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,  /* 00000048    ". !"#$%&" */
    0x16,0x15,0x0A,0x10,0x16,0x17,0x18,0x19,  /* 00000050    "........" */
    0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,  /* 00000058    "...... !" */
    0x22,0x23,0x24,0x25                       /* 00000060    ""#$%"     */
};

const unsigned char TemplateMpam[] =
{
    0x4D,0x50,0x41,0x4D,0xFC,0x00,0x00,0x00,  /* 00000000    "MPAM...." */
    0x02,0x34,0x48,0x49,0x53,0x49,0x20,0x20,  /* 00000008    ".4HISI  " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x02,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x20,0x10,0x22,0x20,0x60,0x00,0x00,0x00,  /* 00000020    " ." `..." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "2......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x01,0x00,0x00,0x00,0x11,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x01,0x20,0x00,0x00,0x00,  /* 00000070    ".... ..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,  /* 00000080    "....x..." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0xD0,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "2......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x02,0x00,0x00,0x00,0x12,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00                       /* 000000F8    "...."     */
};

const unsigned char TemplateMpst[] =
{
    0x4D,0x50,0x53,0x54,0xB6,0x00,0x00,0x00,  /* 00000000    "MPST...." */
    0x01,0x77,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".wINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x13,0x09,0x12,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000040    "........" */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000068    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00             /* 000000B0    "......"   */
};

const unsigned char TemplateMsct[] =
{
    0x4D,0x53,0x43,0x54,0x90,0x00,0x00,0x00,  /* 00000000    "MSCT...." */
    0x01,0xB7,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x38,0x00,0x00,0x00,  /* 00000020    "(.. 8..." */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x00,0x00,  /* 00000030    "........" */
    0x01,0x16,0x00,0x00,0x00,0x00,0x03,0x00,  /* 00000038    "........" */
    0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x40,0x00,0x00,0x00,0x01,0x16,  /* 00000048    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x01,0x16,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x01,0x16,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000088    "........" */
};

const unsigned char TemplateNfit[] =
{
    0x4E,0x46,0x49,0x54,0x88,0x01,0x00,0x00,  /* 00000000    "NFIT...." */
    0x01,0x81,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x13,0x11,0x20,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "..  ...." */
    0x00,0x00,0x40,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x30,0x05,0xAF,0x91,0x86,0x5D,0x0E,0x47,  /* 00000038    "0....].G" */
    0xA6,0xB0,0x0A,0x2D,0xB9,0x40,0x82,0x49,  /* 00000040    "...-.@.I" */
    0x00,0x00,0x00,0x7C,0x03,0x00,0x00,0x00,  /* 00000048    "...|...." */
    0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0xEF,0xCD,0xAB,0x78,0x56,0x34,0x12,  /* 00000060    "....xV4." */
    0x01,0x00,0x30,0x00,0x01,0x00,0x00,0x00,  /* 00000068    "..0....." */
    0x04,0x00,0x00,0x00,0x01,0x00,0x01,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x01,0x00,0x03,0x00,0x2A,0x00,0x00,0x00,  /* 00000090    "....*..." */
    0x02,0x00,0x20,0x00,0x01,0x00,0x00,0x00,  /* 00000098    ".. ....." */
    0x04,0x00,0x00,0x00,0x00,0x01,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x06,0x00,0x00,0x00,0x09,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x03,0x00,0x28,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "..(....." */
    0xB4,0x13,0x5D,0x40,0x91,0x0B,0x29,0x93,  /* 000000C0    "..]@..)." */
    0x67,0xE8,0x23,0x4C,0x00,0x00,0x00,0x88,  /* 000000C8    "g.#L...." */
    0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,  /* 000000D0    ".."3DUfw" */
    0x88,0x99,0xAA,0xBB,0xCC,0xDD,0xEE,0xFF,  /* 000000D8    "........" */
    0x04,0x00,0x50,0x00,0x01,0x00,0x86,0x80,  /* 000000E0    "..P....." */
    0x17,0x20,0x01,0x00,0x86,0x80,0x17,0x20,  /* 000000E8    ". ..... " */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x89,0x00,0x54,0x76,0x01,0x03,0x00,0x01,  /* 000000F8    "..Tv...." */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    ". ......" */
    0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x10,0x80,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x05,0x00,0x28,0x00,0x01,0x00,0x00,0x01,  /* 00000130    "..(....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    ". ......" */
    0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x06,0x00,0x20,0x00,0x01,0x00,0x00,0x00,  /* 00000158    ".. ....." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0x00,0x00,0x00,0x18,0x04,0x00,0x00,0x00,  /* 00000168    "........" */
    0x00,0x00,0x00,0x18,0x06,0x00,0x00,0x00,  /* 00000170    "........" */
    0x07,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000180    "........" */
};

const unsigned char TemplateNhlt[] =
{
    0x4E,0x48,0x4C,0x54,0x1E,0x02,0x00,0x00,  /* 00000000    "NHLT...." */
    0x01,0xF7,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x30,0x09,0x21,0x20,0x04,0xAD,0x00,0x00,  /* 00000020    "0.! ...." */
    0x00,0x02,0x06,0x07,0x00,0x30,0xAE,0x09,  /* 00000028    ".....0.." */
    0x00,0x0A,0x00,0x00,0x00,0x02,0x03,0x0D,  /* 00000030    "........" */
    0x38,0x00,0x00,0x00,0xCC,0x01,0x1F,0x02,  /* 00000038    "8......." */
    0x04,0x00,0x13,0x00,0x09,0x00,0x11,0x00,  /* 00000040    "........" */
    0x04,0x20,0x07,0x00,0x09,0x00,0x18,0x00,  /* 00000048    ". ......" */
    0x22,0x00,0x11,0x00,0x15,0x00,0x05,0x03,  /* 00000050    ""......." */
    0x13,0x00,0x09,0x00,0x11,0x00,0x04,0x20,  /* 00000058    "....... " */
    0x07,0x00,0x09,0x00,0x18,0x00,0x22,0x00,  /* 00000060    "......"." */
    0x11,0x00,0x15,0x00,0xAA,0xAA,0x99,0x99,  /* 00000068    "........" */
    0x78,0x56,0x34,0x12,0x02,0xFE,0xFF,0x78,  /* 00000070    "xV4....x" */
    0x56,0x44,0x33,0x00,0x00,0x66,0x55,0x00,  /* 00000078    "VD3..fU." */
    0x00,0x00,0x80,0x16,0x00,0x32,0x00,0x04,  /* 00000080    ".....2.." */
    0x00,0x99,0x99,0x88,0x88,0x6E,0x88,0x9F,  /* 00000088    ".....n.." */
    0xA6,0xEB,0x6C,0x94,0x45,0xA4,0x1F,0x7B,  /* 00000090    "..l.E..{" */
    0x5D,0xCE,0x24,0xC5,0x53,0x02,0x00,0x00,  /* 00000098    "].$.S..." */
    0x00,0x30,0x40,0xFE,0xFF,0x78,0x56,0x44,  /* 000000A0    ".0@..xVD" */
    0x33,0x00,0x00,0x66,0x55,0x00,0x00,0x00,  /* 000000A8    "3..fU..." */
    0x80,0x16,0x00,0x32,0x00,0x04,0x00,0x99,  /* 000000B0    "...2...." */
    0x99,0x88,0x88,0x6E,0x88,0x9F,0xA6,0xEB,  /* 000000B8    "...n...." */
    0x6C,0x94,0x45,0xA4,0x1F,0x7B,0x5D,0xCE,  /* 000000C0    "l.E..{]." */
    0x24,0xC5,0x53,0x03,0x00,0x00,0x00,0x50,  /* 000000C8    "$.S....P" */
    0x60,0x70,0x48,0x00,0x00,0x00,0x05,0x06,  /* 000000D0    "`pH....." */
    0x07,0x00,0x34,0xAE,0x09,0x00,0x0A,0x00,  /* 000000D8    "..4....." */
    0x00,0x00,0x02,0x00,0x0D,0x02,0x00,0x00,  /* 000000E0    "........" */
    0x00,0xCC,0x00,0x01,0xFE,0xFF,0x78,0x56,  /* 000000E8    "......xV" */
    0x44,0x33,0x00,0x00,0x66,0x55,0x00,0x00,  /* 000000F0    "D3..fU.." */
    0x00,0x80,0x16,0x00,0x32,0x00,0x04,0x00,  /* 000000F8    "....2..." */
    0x99,0x99,0x88,0x88,0x6E,0x88,0x9F,0xA6,  /* 00000100    "....n..." */
    0xEB,0x6C,0x94,0x45,0xA4,0x1F,0x7B,0x5D,  /* 00000108    ".l.E..{]" */
    0xCE,0x24,0xC5,0x53,0x02,0x00,0x00,0x00,  /* 00000110    ".$.S...." */
    0x70,0x80,0x80,0x00,0x00,0x00,0x02,0x06,  /* 00000118    "p......." */
    0x07,0x00,0x30,0xAE,0x09,0x00,0x0A,0x00,  /* 00000120    "..0....." */
    0x00,0x00,0x02,0x03,0x0D,0x07,0x00,0x00,  /* 00000128    "........" */
    0x00,0xCC,0x03,0x09,0x34,0x12,0x28,0x01,  /* 00000130    "....4.(." */
    0x02,0xFE,0xFF,0x78,0x56,0x44,0x33,0x00,  /* 00000138    "...xVD3." */
    0x00,0x66,0x55,0x00,0x00,0x00,0x80,0x16,  /* 00000140    ".fU....." */
    0x00,0x32,0x00,0x04,0x00,0x99,0x99,0x88,  /* 00000148    ".2......" */
    0x88,0x6E,0x88,0x9F,0xA6,0xEB,0x6C,0x94,  /* 00000150    ".n....l." */
    0x45,0xA4,0x1F,0x7B,0x5D,0xCE,0x24,0xC5,  /* 00000158    "E..{].$." */
    0x53,0x04,0x00,0x00,0x00,0x70,0x80,0x90,  /* 00000160    "S....p.." */
    0xA0,0xFE,0xFF,0x78,0x56,0x44,0x33,0x00,  /* 00000168    "...xVD3." */
    0x00,0x66,0x55,0x00,0x00,0x00,0x80,0x16,  /* 00000170    ".fU....." */
    0x00,0x32,0x00,0x04,0x00,0x99,0x99,0x88,  /* 00000178    ".2......" */
    0x88,0x6E,0x88,0x9F,0xA6,0xEB,0x6C,0x94,  /* 00000180    ".n....l." */
    0x45,0xA4,0x1F,0x7B,0x5D,0xCE,0x24,0xC5,  /* 00000188    "E..{].$." */
    0x53,0x05,0x00,0x00,0x00,0x70,0x80,0x90,  /* 00000190    "S....p.." */
    0xA0,0xB0,0x7C,0x00,0x00,0x00,0x05,0x06,  /* 00000198    "..|....." */
    0x07,0x00,0x34,0xAE,0x09,0x00,0x0A,0x00,  /* 000001A0    "..4....." */
    0x00,0x00,0x02,0x00,0x0D,0x02,0x00,0x00,  /* 000001A8    "........" */
    0x00,0xCC,0x00,0x01,0xFE,0xFF,0x78,0x56,  /* 000001B0    "......xV" */
    0x44,0x33,0x00,0x00,0x66,0x55,0x00,0x00,  /* 000001B8    "D3..fU.." */
    0x00,0x80,0x16,0x00,0x32,0x00,0x04,0x00,  /* 000001C0    "....2..." */
    0x99,0x99,0x88,0x88,0x6E,0x88,0x9F,0xA6,  /* 000001C8    "....n..." */
    0xEB,0x6C,0x94,0x45,0xA4,0x1F,0x7B,0x5D,  /* 000001D0    ".l.E..{]" */
    0xCE,0x24,0xC5,0x53,0x11,0x00,0x00,0x00,  /* 000001D8    ".$.S...." */
    0x00,0x01,0x32,0x03,0x04,0x05,0x06,0x37,  /* 000001E0    "..2....7" */
    0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x3F,  /* 000001E8    ".......?" */
    0x0A,0x01,0x00,0x01,0x32,0x03,0x04,0x05,  /* 000001F0    "....2..." */
    0x06,0x37,0x08,0x09,0x0A,0x0B,0x0C,0x0D,  /* 000001F8    ".7......" */
    0x0E,0x3F,0x44,0x9A,0x00,0x01,0x32,0x03,  /* 00000200    ".?D...2." */
    0x04,0x05,0x06,0x37,0x08,0x09,0x0A,0x0B,  /* 00000208    "...7...." */
    0x0C,0x0D,0x0E,0x3F,0x0A,0x0B,0x04,0x00,  /* 00000210    "...?...." */
    0x00,0x00,0xEF,0xBE,0xAD,0xDE             /* 00000218    "......"   */
};

const unsigned char TemplatePcct[] =
{
    0x50,0x43,0x43,0x54,0xAE,0x02,0x00,0x00,  /* 00000000    "PCCT...." */
    0x01,0xE6,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x25,0x09,0x20,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "%.  ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    ".>......" */
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,  /* 00000038    "........" */
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,  /* 00000040    """""""""" */
    0x01,0x32,0x00,0x03,0x33,0x33,0x33,0x33,  /* 00000048    ".2..3333" */
    0x33,0x33,0x33,0x33,0x44,0x44,0x44,0x44,  /* 00000050    "3333DDDD" */
    0x44,0x44,0x44,0x44,0x55,0x55,0x55,0x55,  /* 00000058    "DDDDUUUU" */
    0x55,0x55,0x55,0x55,0x66,0x66,0x66,0x66,  /* 00000060    "UUUUffff" */
    0x77,0x77,0x77,0x77,0x88,0x88,0x01,0x3E,  /* 00000068    "wwww...>" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x32,  /* 00000080    ".......2" */
    0x00,0x03,0x44,0x44,0x44,0x44,0x44,0x44,  /* 00000088    "..DDDDDD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,  /* 00000090    "DDDDDDDD" */
    0x44,0x44,0x55,0x55,0x55,0x55,0x55,0x55,  /* 00000098    "DDUUUUUU" */
    0x55,0x55,0x66,0x66,0x66,0x66,0x77,0x77,  /* 000000A0    "UUffffww" */
    0x77,0x77,0x88,0x88,0x02,0x5A,0x01,0x00,  /* 000000A8    "ww...Z.." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x32,0x00,0x03,  /* 000000C0    ".....2.." */
    0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,  /* 000000C8    "DDDDDDDD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,  /* 000000D0    "DDDDDDDD" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,  /* 000000D8    "UUUUUUUU" */
    0x66,0x66,0x66,0x66,0x77,0x77,0x77,0x77,  /* 000000E0    "ffffwwww" */
    0x88,0x88,0x01,0x32,0x00,0x03,0x33,0x33,  /* 000000E8    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x44,0x44,  /* 000000F0    "333333DD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x55,0x55,  /* 000000F8    "DDDDDDUU" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x03,0xA4,  /* 00000100    "UUUUUU.." */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000118    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x44,0x44,  /* 00000120    "333333DD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x55,0x55,  /* 00000128    "DDDDDDUU" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x66,0x66,  /* 00000130    "UUUUUUff" */
    0x66,0x66,0x77,0x77,0x77,0x77,0x88,0x88,  /* 00000138    "ffwwww.." */
    0x88,0x88,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000140    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x99,0x99,  /* 00000148    "333333.." */
    0x99,0x99,0x99,0x99,0x99,0x99,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x32,  /* 00000160    ".......2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000168    "..333333" */
    0x33,0x33,0x22,0x22,0x22,0x22,0x22,0x22,  /* 00000170    "33""""""" */
    0x22,0x22,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000178    """.2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000180    "33333333" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x44,0x44,  /* 00000188    "333333DD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x01,0x32,  /* 00000190    "DDDDDD.2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000198    "..333333" */
    0x33,0x33,0x55,0x55,0x55,0x55,0x55,0x55,  /* 000001A0    "33UUUUUU" */
    0x55,0x55,0x04,0xA4,0x01,0x00,0x00,0x00,  /* 000001A8    "UU......" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x32,  /* 000001B8    ".......2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 000001C0    "..333333" */
    0x33,0x33,0x44,0x44,0x44,0x44,0x44,0x44,  /* 000001C8    "33DDDDDD" */
    0x44,0x44,0x55,0x55,0x55,0x55,0x55,0x55,  /* 000001D0    "DDUUUUUU" */
    0x55,0x55,0x66,0x66,0x66,0x66,0x77,0x77,  /* 000001D8    "UUffffww" */
    0x77,0x77,0x88,0x88,0x88,0x88,0x01,0x32,  /* 000001E0    "ww.....2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 000001E8    "..333333" */
    0x33,0x33,0x99,0x99,0x99,0x99,0x99,0x99,  /* 000001F0    "33......" */
    0x99,0x99,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0x00,0x00,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000208    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x22,0x22,  /* 00000210    "333333""" */
    0x22,0x22,0x22,0x22,0x22,0x22,0x01,0x32,  /* 00000218    """"""".2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000220    "..333333" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000228    "33333333" */
    0x33,0x33,0x44,0x44,0x44,0x44,0x44,0x44,  /* 00000230    "33DDDDDD" */
    0x44,0x44,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000238    "DD.2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x55,0x55,  /* 00000240    "333333UU" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x05,0x60,  /* 00000248    "UUUUUU.`" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000250    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000258    "........" */
    0x00,0x00,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000260    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000268    "33333333" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000270    "33333333" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x01,0x32,  /* 00000278    "333333.2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000280    "..333333" */
    0x33,0x33,0x44,0x44,0x44,0x44,0x44,0x44,  /* 00000288    "33DDDDDD" */
    0x44,0x44,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000290    "DD.2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x55,0x55,  /* 00000298    "333333UU" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x03,0x00,  /* 000002A0    "UUUUUU.." */
    0x00,0x00,0x05,0x00,0x00,0x00             /* 000002A8    "......"   */
};

const unsigned char TemplatePdtt[] =
{
    0x50,0x44,0x54,0x54,0x34,0x00,0x00,0x00,  /* 00000000    "PDTT4..." */
    0x01,0xCB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x08,0x17,0x20,0x04,0x00,0x00,0x00,  /* 00000020    "1.. ...." */
    0x2C,0x00,0x00,0x00,0xAA,0x03,0xBB,0x02,  /* 00000028    ",......." */
    0xCC,0x01,0xDD,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplatePhat [] =
{
    0x50,0x48,0x41,0x54,0xA2,0x00,0x00,0x00,  /* 00000000    "PHAT...." */
    0x01,0xCA,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x22,0x20,0x00,0x00,0x28,0x00,  /* 00000020    "1." ..(." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "........" */
    0x30,0x05,0xAF,0x91,0x86,0x5D,0x0E,0x47,  /* 00000030    "0....].G" */
    0xA6,0xB0,0x0A,0x2D,0xB9,0x40,0x82,0x49,  /* 00000038    "...-.@.I" */
    0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,  /* 00000040    "........" */
    0x0C,0x0B,0x0A,0x09,0x01,0x00,0x2E,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x30,0x05,0xAF,0x91,  /* 00000050    "....0..." */
    0x86,0x5D,0x0E,0x47,0xA6,0xB0,0x0A,0x2D,  /* 00000058    ".].G...-" */
    0xB9,0x40,0x82,0x49,0x2A,0x00,0x00,0x00,  /* 00000060    ".@.I*..." */
    0x41,0x00,0x42,0x00,0x43,0x00,0x44,0x00,  /* 00000068    "A.B.C.D." */
    0x45,0x00,0x46,0x00,0x00,0x00,0x01,0x02,  /* 00000070    "E.F....." */
    0x03,0x04,0x00,0x00,0x28,0x00,0x00,0x00,  /* 00000078    "....(..." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x30,0x05,  /* 00000080    "......0." */
    0xAF,0x91,0x86,0x5D,0x0E,0x47,0xA6,0xB0,  /* 00000088    "...].G.." */
    0x0A,0x2D,0xB9,0x40,0x82,0x49,0x08,0x07,  /* 00000090    ".-.@.I.." */
    0x06,0x05,0x04,0x03,0x02,0x01,0x0C,0x0B,  /* 00000098    "........" */
    0x0A,0x09                                 /* 000000A0    ".."       */
};

const unsigned char TemplatePmtt[] =
{
    0x50,0x4D,0x54,0x54,0xBB,0x00,0x00,0x00,  /* 00000000    "PMTT...." */
    0x02,0x2E,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x05,0x01,0x21,0x20,0x08,0x00,0x00,0x00,  /* 00000020    "..! ...." */
    0x00,0x00,0x10,0x00,0x0D,0x00,0x00,0x00,  /* 00000028    "........" */
    0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x01,0x00,0x10,0x00,0x04,0x00,0x00,0x00,  /* 00000038    "........" */
    0x02,0x00,0x00,0x00,0x44,0x44,0x00,0x00,  /* 00000040    "....DD.." */
    0x02,0x00,0x10,0x00,0x04,0x00,0x00,0x00,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x78,0x56,0x34,0x12,  /* 00000050    "....xV4." */
    0xFF,0x00,0x23,0x00,0x0D,0x00,0x00,0x00,  /* 00000058    "..#....." */
    0x03,0x00,0x00,0x00,0x03,0x02,0x01,0x00,  /* 00000060    "........" */
    0x08,0x04,0x07,0x06,0x08,0x09,0x0A,0x0B,  /* 00000068    "........" */
    0x0C,0x0D,0x0E,0x0F,0x55,0x66,0x77,0x88,  /* 00000070    "....Ufw." */
    0x11,0xAA,0xBB,0x00,0x00,0x10,0x00,0x0D,  /* 00000078    "........" */
    0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,  /* 00000080    "........" */
    0x00,0x00,0x00,0x01,0x00,0x10,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x02,0x00,0x10,0x00,0x04,  /* 00000098    "........" */
    0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x78,  /* 000000A0    ".......x" */
    0x56,0x34,0x12,0x02,0x00,0x10,0x00,0x04,  /* 000000A8    "V4......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,  /* 000000B0    ".......x" */
    0x56,0x34,0x12                            /* 000000B8    "V4."      */
};

const unsigned char TemplatePptt[] =
{
    0x50,0x50,0x54,0x54,0x72,0x00,0x00,0x00,  /* 00000000    "PPTTr..." */
    0x01,0x86,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x03,0x03,0x17,0x20,0x00,0x18,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x01,0x18,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x02,0x1E,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00                                 /* 00000070    ".."       */
};

const unsigned char TemplatePrmt[] =
{
    0x50,0x52,0x4D,0x54,0xB8,0x02,0x00,0x00,  /* 00000000    "PRMT...." */
    0x00,0x13,0x4F,0x45,0x4D,0x43,0x41,0x20,  /* 00000008    "..OEMCA " */
    0x4F,0x45,0x4D,0x43,0x41,0x20,0x20,0x20,  /* 00000010    "OEMCA   " */
    0x02,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x07,0x20,0x20,0xA5,0x61,0x6B,0xB6,  /* 00000020    "..  .ak." */
    0x01,0xA1,0x46,0xED,0xA6,0xA3,0xCA,0xC1,  /* 00000028    "..F....." */
    0xC4,0xD1,0x30,0x1E,0x3C,0x00,0x00,0x00,  /* 00000030    "..0.<..." */
    0x04,0x00,0x00,0x00,0x00,0x00,0xAA,0x00,  /* 00000038    "........" */
    0xC2,0xB3,0x52,0x16,0xA1,0xA7,0xAC,0x46,  /* 00000040    "..R....F" */
    0xAF,0x93,0xDD,0x6D,0xEE,0x44,0x66,0x69,  /* 00000048    "...m.Dfi" */
    0x01,0x00,0x00,0x00,0x03,0x00,0x26,0x00,  /* 00000050    "......&." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0x5F,0xAD,  /* 00000060    "....,._." */
    0xF2,0xD5,0x47,0xA3,0x3E,0x4D,0x87,0xBC,  /* 00000068    "..G.>M.." */
    0xC2,0xCE,0x63,0x02,0x9C,0xC8,0x90,0xC2,  /* 00000070    "..c....." */
    0x5E,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "^......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x2C,0x00,0xC3,0xAD,0xE7,0xA9,0xD0,0x8C,  /* 00000090    ",......." */
    0x9A,0x42,0x89,0x15,0x10,0x94,0x6E,0xBD,  /* 00000098    ".B....n." */
    0xE3,0x18,0xC0,0xC2,0x5E,0x8A,0x00,0x00,  /* 000000A0    "....^..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0x14,0xC2,  /* 000000B8    "....,..." */
    0x88,0xB6,0x81,0x40,0xEB,0x4E,0x8D,0x26,  /* 000000C0    "...@.N.&" */
    0x1E,0xB5,0xA3,0xBC,0xF1,0x1A,0xF0,0xC2,  /* 000000C8    "........" */
    0x5E,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D0    "^......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x52,0x00,0xA6,0x58,0x2A,0xDC,0x27,0x59,  /* 000000E8    "R..X*.'Y" */
    0x76,0x47,0xB9,0x95,0xD1,0x18,0xA2,0x73,  /* 000000F0    "vG.....s" */
    0x35,0xA2,0x01,0x00,0x00,0x00,0x01,0x00,  /* 000000F8    "5......." */
    0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "&......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x00,  /* 00000108    "......,." */
    0x13,0x2D,0x4F,0x2E,0x40,0x62,0xD0,0x4E,  /* 00000110    ".-O.@b.N" */
    0xA4,0x01,0xC7,0x23,0xFB,0xDC,0x34,0xE8,  /* 00000118    "...#..4." */
    0x90,0x32,0x5E,0x8A,0x00,0x00,0x00,0x00,  /* 00000120    ".2^....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0xF8,0x7F,0x71,0x8A,0x00,0x00,0x00,0x00,  /* 00000130    "..q....." */
    0x00,0x00,0x2E,0x01,0xD7,0x3E,0xF9,0x0E,  /* 00000138    ".....>.." */
    0xAE,0x14,0x5B,0x42,0x92,0x8F,0xB8,0x5A,  /* 00000140    "..[B...Z" */
    0x62,0x13,0xB5,0x7E,0x01,0x00,0x00,0x00,  /* 00000148    "b..~...." */
    0x06,0x00,0x26,0x00,0x00,0x00,0xE0,0x3F,  /* 00000150    "..&....?" */
    0x71,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "q......." */
    0x2C,0x00,0x3C,0xCD,0x20,0x21,0x8B,0x84,  /* 00000160    ",.<. !.." */
    0x8F,0x4D,0xAB,0xBB,0x4B,0x74,0xCE,0x64,  /* 00000168    ".M..Kt.d" */
    0xAC,0x89,0x4C,0xA6,0x5D,0x8A,0x00,0x00,  /* 00000170    "..L.]..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0xA7,0x35,  /* 00000188    "....,..5" */
    0x09,0xEA,0x6B,0x50,0x59,0x41,0xBB,0xBB,  /* 00000190    "..kPYA.." */
    0x48,0xDE,0xEE,0xCB,0x6F,0x58,0x34,0xA7,  /* 00000198    "H...oX4." */
    0x5D,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A0    "]......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B0    "........" */
    0x2C,0x00,0xA9,0xBD,0xD1,0x1B,0x9A,0x90,  /* 000001B8    ",......." */
    0x14,0x46,0x96,0x99,0x25,0xEC,0x0C,0x27,  /* 000001C0    ".F..%..'" */
    0x83,0xF7,0x94,0xA7,0x5D,0x8A,0x00,0x00,  /* 000001C8    "....]..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0xE7,0xB4,  /* 000001E0    "....,..." */
    0x28,0x5D,0x67,0x38,0xEE,0x4A,0xAA,0x09,  /* 000001E8    "(]g8.J.." */
    0x51,0xFC,0x28,0x2C,0x3B,0x22,0x9C,0xA6,  /* 000001F0    "Q.(,;".." */
    0x5D,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "]......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000208    "........" */
    0x2C,0x00,0x02,0xB7,0x64,0x4B,0x2B,0x4D,  /* 00000210    ",...dK+M" */
    0xFE,0x4D,0xAC,0x5A,0x0B,0x41,0x10,0xA2,  /* 00000218    ".M.Z.A.." */
    0xCA,0x47,0x48,0xA7,0x5D,0x8A,0x00,0x00,  /* 00000220    ".GH.]..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000230    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0xDE,0xFD,  /* 00000238    "....,..." */
    0x0E,0x8A,0xD0,0x78,0xF0,0x45,0xAE,0xA0,  /* 00000240    "...x.E.." */
    0xC2,0x82,0x45,0xC7,0xE1,0xDB,0x98,0xA7,  /* 00000248    "..E....." */
    0x5D,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000250    "]......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000258    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000260    "........" */
    0x52,0x00,0x2B,0xF4,0x6C,0x5A,0xB4,0x8B,  /* 00000268    "R.+.lZ.." */
    0x2C,0x47,0xA2,0x33,0x5C,0x4D,0xC4,0x03,  /* 00000270    ",G.3\M.." */
    0x3D,0xC7,0x01,0x00,0x00,0x00,0x01,0x00,  /* 00000278    "=......." */
    0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000280    "&......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x00,  /* 00000288    "......,." */
    0x81,0x60,0x46,0xE1,0x62,0x75,0x0F,0x43,  /* 00000290    ".`F.bu.C" */
    0x89,0x6B,0xB0,0xE5,0x23,0xDC,0x33,0x5A,  /* 00000298    ".k..#.3Z" */
    0x90,0x12,0x5D,0x8A,0x00,0x00,0x00,0x00,  /* 000002A0    "..]....." */
    0xE0,0x5F,0x71,0x8A,0x00,0x00,0x00,0x00,  /* 000002A8    "._q....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 000002B0    "........" */
};

const unsigned char TemplateRasf[] =
{
    0x52,0x41,0x53,0x46,0x30,0x00,0x00,0x00,  /* 00000000    "RASF0..." */
    0x01,0x31,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".1INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x27,0x05,0x16,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "'.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000028    "........" */
};

const unsigned char TemplateRgrt[] =
{
    0x52,0x47,0x52,0x54,0x50,0x00,0x00,0x00,  /* 00000000    "RGRTP..." */
    0x01,0x33,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".3INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x21,0x20,0x01,0x00,0x01,0x00,  /* 00000020    "1.! ...." */
    0xAA,0x01,0x02,0x03,0x04,0x05,0x06,0x07,  /* 00000028    "........" */
    0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,  /* 00000030    "........" */
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,  /* 00000038    "........" */
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,  /* 00000040    "........" */
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27   /* 00000048    " !"#$%&'" */
};

const unsigned char TemplateRhct[] =
{
    0x52,0x48,0x43,0x54,0x96,0x00,0x00,0x00,  /* 00000000    "RHCT|..." */
    0x01,0x24,0x4F,0x45,0x4D,0x43,0x41,0x00,  /* 00000008    "..OEMCA." */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x09,0x22,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x80,0x96,0x98,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x02,0x00,0x00,0x00,0x38,0x00,0x00,0x00,  /* 00000030    "....8..." */
    0x00,0x00,0x34,0x00,0x01,0x00,0x2B,0x00,  /* 00000038    "..4...*." */
    0x72,0x76,0x36,0x34,0x69,0x6D,0x61,0x66,  /* 00000040    "rv64imaf" */
    0x64,0x63,0x68,0x5F,0x7A,0x69,0x63,0x73,  /* 00000048    "dch_zics" */
    0x72,0x5F,0x7A,0x69,0x66,0x65,0x6E,0x63,  /* 00000050    "r_zifenc" */
    0x65,0x69,0x5F,0x7A,0x62,0x61,0x5F,0x7A,  /* 00000058    "ei_zba_z" */
    0x62,0x62,0x5F,0x7A,0x62,0x63,0x5F,0x7A,  /* 00000060    "bb_zbc_z" */
    0x62,0x73,0x00,0x00,0xFF,0xFF,0x18,0x00,  /* 00000068    "bs......" */
    0x01,0x00,0x03,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x38,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,  /* 00000078    "........" */
    0x8E,0x00,0x00,0x00,0x01,0x00,0x0A,0x00,  /* 00000080    "........" */
    0x01,0x00,0x00,0x06,0x06,0x06,0x02,0x00,  /* 00000088    "........" */
    0x08,0x00,0x01,0x00,0x00,0x02             /* 00000090    "........" */
};

const unsigned char TemplateRsdp[] =
{
    0x52,0x53,0x44,0x20,0x50,0x54,0x52,0x20,  /* 00000000    "RSD PTR " */
    0x43,0x49,0x4E,0x54,0x45,0x4C,0x20,0x02,  /* 00000008    "CINTEL ." */
    0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x00,  /* 00000010    "....$..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0xDC,0x00,0x00,0x00                       /* 00000020    "...."     */
};

const unsigned char TemplateRsdt[] =
{
    0x52,0x53,0x44,0x54,0x44,0x00,0x00,0x00,  /* 00000000    "RSDTD..." */
    0x01,0xB1,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x10,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x20,0x00,0x00,0x00,0x30,0x00,0x00,0x00,  /* 00000028    " ...0..." */
    0x40,0x00,0x00,0x00,0x50,0x00,0x00,0x00,  /* 00000030    "@...P..." */
    0x60,0x00,0x00,0x00,0x70,0x00,0x00,0x00,  /* 00000038    "`...p..." */
    0x80,0x00,0x00,0x00                       /* 00000040    "...."     */
};

const unsigned char TemplateS3pt[] =
{
    0x53,0x33,0x50,0x54,0x34,0x00,0x00,0x00,  /* 00000000    "S3PT4..." */
    0x00,0x00,0x18,0x01,0x00,0x00,0x00,0x00,  /* 00000008    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000010    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0x01,0x00,0x14,0x01,0x00,0x00,0x00,0x00,  /* 00000020    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateSbst[] =
{
    0x53,0x42,0x53,0x54,0x30,0x00,0x00,0x00,  /* 00000000    "SBST0..." */
    0x01,0x06,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000028    "........" */
};

const unsigned char TemplateSdei[] =
{
    0x53,0x44,0x45,0x49,0x3e,0x00,0x00,0x00,  /* 00000000    "SDEI>..." */
    0x01,0x59,0x41,0x52,0x4d,0x20,0x20,0x20,  /* 00000008    ".mARM  " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x30,0x09,0x16,0x20                       /* 00000028    "0.. " */
};

const unsigned char TemplateSdev[] =
{
    0x53,0x44,0x45,0x56,0x89,0x00,0x00,0x00,  /* 00000000    "SDEV...." */
    0x01,0x6E,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".nINTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x05,0x01,0x21,0x20,0x00,0x03,0x41,0x00,  /* 00000020    "..! ..A." */
    0x23,0x00,0x16,0x00,0x39,0x00,0x08,0x00,  /* 00000028    "#...9..." */
    0x10,0x00,0x13,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,  /* 00000038    "........" */
    0x09,0x08,0x0A,0x0B,0x0C,0x0D,0x0E,0x5C,  /* 00000040    ".......\" */
    0x5C,0x5F,0x53,0x42,0x5F,0x2E,0x50,0x43,  /* 00000048    "\_SB_.PC" */
    0x49,0x30,0x2E,0x55,0x53,0x42,0x31,0x2E,  /* 00000050    "I0.USB1." */
    0x53,0x55,0x42,0x31,0x00,0x00,0x11,0x22,  /* 00000058    "SUB1..."" */
    0x33,0x44,0x55,0x66,0x77,0x01,0x01,0x24,  /* 00000060    "3DUfw..$" */
    0x00,0x10,0x00,0x20,0x00,0x10,0x00,0x04,  /* 00000068    "... ...." */
    0x00,0x14,0x00,0x10,0x00,0x11,0x22,0x33,  /* 00000070    "......"3" */
    0x44,0xEE,0xDD,0xCC,0xBB,0xAA,0x55,0x66,  /* 00000078    "D.....Uf" */
    0x77,0x88,0x99,0xAA,0xBB,0xCC,0xDD,0xEE,  /* 00000080    "w......." */
    0xFF                                      /* 00000088    "."        */
};

const unsigned char TemplateSlic[] =
{
    0x53,0x4C,0x49,0x43,0x76,0x01,0x00,0x00,  /* 00000000    "SLICv..." */
    0x01,0x07,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x11,0x02,0x11,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x9C,0x00,0x00,0x00,0x06,0x02,0x00,0x00,  /* 00000028    "........" */
    0x00,0x24,0x00,0x00,0x52,0x53,0x41,0x31,  /* 00000030    ".$..RSA1" */
    0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x01,0x00,0x00,0x00,0xB6,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x02,0x00,0x49,0x4E,0x54,0x45,  /* 000000C8    "....INTE" */
    0x4C,0x20,0x54,0x45,0x4D,0x50,0x4C,0x41,  /* 000000D0    "L TEMPLA" */
    0x54,0x45,0x57,0x49,0x4E,0x44,0x4F,0x57,  /* 000000D8    "TEWINDOW" */
    0x53,0x20,0x01,0x00,0x02,0x00,0x00,0x00,  /* 000000E0    "S ......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000168    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00             /* 00000170    "......"   */
};

const unsigned char TemplateSlit[] =
{
    0x53,0x4C,0x49,0x54,0xBC,0x01,0x00,0x00,  /* 00000000    "SLIT...." */
    0x01,0x00,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x16,0x03,0x11,0x20,0x14,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x0A,0x10,0x16,0x17,  /* 00000028    "........" */
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,  /* 00000030    "........" */
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,  /* 00000038    " !"#$%&'" */
    0x10,0x0A,0x15,0x16,0x17,0x18,0x19,0x1A,  /* 00000040    "........" */
    0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,  /* 00000048    "..... !"" */
    0x23,0x24,0x25,0x26,0x16,0x15,0x0A,0x10,  /* 00000050    "#$%&...." */
    0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,  /* 00000058    "........" */
    0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,  /* 00000060    ".. !"#$%" */
    0x17,0x16,0x10,0x0A,0x15,0x16,0x17,0x18,  /* 00000068    "........" */
    0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,  /* 00000070    "....... " */
    0x21,0x22,0x23,0x24,0x18,0x17,0x16,0x15,  /* 00000078    "!"#$...." */
    0x0A,0x10,0x16,0x17,0x18,0x19,0x1A,0x1B,  /* 00000080    "........" */
    0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,  /* 00000088    ".... !"#" */
    0x19,0x18,0x17,0x16,0x10,0x0A,0x15,0x16,  /* 00000090    "........" */
    0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,  /* 00000098    "........" */
    0x1F,0x20,0x21,0x22,0x1A,0x19,0x18,0x17,  /* 000000A0    ". !"...." */
    0x16,0x15,0x0A,0x10,0x16,0x17,0x18,0x19,  /* 000000A8    "........" */
    0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,  /* 000000B0    "...... !" */
    0x1B,0x1A,0x19,0x18,0x17,0x16,0x10,0x0A,  /* 000000B8    "........" */
    0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,  /* 000000C0    "........" */
    0x1D,0x1E,0x1F,0x20,0x1C,0x1B,0x1A,0x19,  /* 000000C8    "... ...." */
    0x18,0x17,0x16,0x15,0x0A,0x10,0x16,0x17,  /* 000000D0    "........" */
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,  /* 000000D8    "........" */
    0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,  /* 000000E0    "........" */
    0x10,0x0A,0x15,0x16,0x17,0x18,0x19,0x1A,  /* 000000E8    "........" */
    0x1B,0x1C,0x1D,0x1E,0x1E,0x1D,0x1C,0x1B,  /* 000000F0    "........" */
    0x1A,0x19,0x18,0x17,0x16,0x15,0x0A,0x10,  /* 000000F8    "........" */
    0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,  /* 00000100    "........" */
    0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,  /* 00000108    "........" */
    0x17,0x16,0x10,0x0A,0x15,0x16,0x17,0x18,  /* 00000110    "........" */
    0x19,0x1A,0x1B,0x1C,0x20,0x1F,0x1E,0x1D,  /* 00000118    ".... ..." */
    0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,0x15,  /* 00000120    "........" */
    0x0A,0x10,0x16,0x17,0x18,0x19,0x1A,0x1B,  /* 00000128    "........" */
    0x21,0x20,0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,  /* 00000130    "! ......" */
    0x19,0x18,0x17,0x16,0x10,0x0A,0x15,0x16,  /* 00000138    "........" */
    0x17,0x18,0x19,0x1A,0x22,0x21,0x20,0x1F,  /* 00000140    "...."! ." */
    0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,  /* 00000148    "........" */
    0x16,0x15,0x0A,0x10,0x16,0x17,0x18,0x19,  /* 00000150    "........" */
    0x23,0x22,0x21,0x20,0x1F,0x1E,0x1D,0x1C,  /* 00000158    "#"! ...." */
    0x1B,0x1A,0x19,0x18,0x17,0x16,0x10,0x0A,  /* 00000160    "........" */
    0x15,0x16,0x17,0x18,0x24,0x23,0x22,0x21,  /* 00000168    "....$#"!" */
    0x20,0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,  /* 00000170    " ......." */
    0x18,0x17,0x16,0x15,0x0A,0x10,0x16,0x17,  /* 00000178    "........" */
    0x25,0x24,0x23,0x22,0x21,0x20,0x1F,0x1E,  /* 00000180    "%$#"! .." */
    0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,  /* 00000188    "........" */
    0x10,0x0A,0x15,0x16,0x26,0x25,0x24,0x23,  /* 00000190    "....&%$#" */
    0x22,0x21,0x20,0x1F,0x1E,0x1D,0x1C,0x1B,  /* 00000198    ""! ....." */
    0x1A,0x19,0x18,0x17,0x16,0x15,0x0A,0x10,  /* 000001A0    "........" */
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,  /* 000001A8    "'&%$#"! " */
    0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,  /* 000001B0    "........" */
    0x17,0x16,0x10,0x0A                       /* 000001B8    "...."     */
};

const unsigned char TemplateSpcr[] =
{
    0x53,0x50,0x43,0x52,0x50,0x00,0x00,0x00,  /* 00000000    "SPCRP..." */
    0x01,0xE3,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000048    "........" */
};

const unsigned char TemplateSpmi[] =
{
    0x53,0x50,0x4D,0x49,0x41,0x00,0x00,0x00,  /* 00000000    "SPMIA..." */
    0x04,0x00,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x14,0x01,0x14,0x20,0x00,0x01,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x08,0x00,0x01,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00                                      /* 00000040    "."        */
};

const unsigned char TemplateSrat[] =
{
    0x53,0x52,0x41,0x54,0xBE,0x00,0x00,0x00,  /* 00000000    "SRAT...." */
    0x03,0xE6,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x29,0x06,0x18,0x20,0x01,0x00,0x00,0x00,  /* 00000020    ").. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x10,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x01,0x28,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    ".(......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0xFC,0x09,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x02,0x18,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x03,0x12,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x04,0x0C,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x20,  /* 00000098    "....... " */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00             /* 000000B8    "......"   */
};

const unsigned char TemplateStao[] =
{
    0x53,0x54,0x41,0x4F,0x7E,0x00,0x00,0x00,  /* 00000000    "STAO~..." */
    0x01,0x7F,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x01,0x5C,0x5F,0x53,  /* 00000020    "... .\_S" */
    0x42,0x30,0x2E,0x42,0x55,0x53,0x30,0x2E,  /* 00000028    "B0.BUS0." */
    0x44,0x45,0x56,0x31,0x00,0x5C,0x5F,0x53,  /* 00000030    "DEV1.\_S" */
    0x42,0x30,0x2E,0x42,0x55,0x53,0x30,0x2E,  /* 00000038    "B0.BUS0." */
    0x44,0x45,0x56,0x32,0x00,0x5C,0x5F,0x53,  /* 00000040    "DEV2.\_S" */
    0x42,0x30,0x2E,0x42,0x55,0x53,0x31,0x2E,  /* 00000048    "B0.BUS1." */
    0x44,0x45,0x56,0x31,0x2E,0x44,0x45,0x56,  /* 00000050    "DEV1.DEV" */
    0x32,0x00,0x5C,0x5F,0x53,0x42,0x30,0x2E,  /* 00000058    "2.\_SB0." */
    0x42,0x55,0x53,0x31,0x2E,0x44,0x45,0x56,  /* 00000060    "BUS1.DEV" */
    0x32,0x2E,0x44,0x45,0x56,0x32,0x00,0x5C,  /* 00000068    "2.DEV2.\" */
    0x55,0x53,0x42,0x31,0x2E,0x48,0x55,0x42,  /* 00000070    "USB1.HUB" */
    0x31,0x2E,0x50,0x54,0x31,0x00             /* 00000078    "1.PT1."   */
};

const unsigned char TemplateSvkl[] =
{
    0x53,0x56,0x4B,0x4C,0x48,0x00,0x00,0x00,  /* 00000000    "SVKLH..." */
    0x04,0xDB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x21,0x20,0x02,0x00,0x00,0x00,  /* 00000020    "1.! ...." */
    0x00,0x00,0x00,0x00,0x21,0x43,0xAA,0xAA,  /* 00000028    "....!C.." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000030    "....gE#." */
    0x00,0x00,0x00,0x00,0x21,0x43,0xBB,0xBB,  /* 00000038    "....!C.." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01   /* 00000040    "....gE#." */
};

const unsigned char TemplateTcpa[] =
{
    0x54,0x43,0x50,0x41,0x64,0x00,0x00,0x00,  /* 00000000    "TCPAd..." */
    0x02,0xFF,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x80,0x31,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    ".1..INTL" */
    0x19,0x06,0x15,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x11,0x00,0xFF,0xEE,0xDD,0xCC,0xBB,0xAA,  /* 00000030    "........" */
    0x02,0x01,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x03,  /* 00000040    "..... .." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x03,  /* 00000050    "..... .." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x01,0x01,0x01                       /* 00000060    "...."     */
};

const unsigned char TemplateTdel[] =
{
    0x54,0x44,0x45,0x4C,0x38,0x00,0x00,0x00,  /* 00000000    "TDEL8..." */
    0x04,0x1C,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x30,0x09,0x21,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "0.! ...." */
    0xEF,0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,  /* 00000028    "...xV4.." */
    0x78,0x56,0x34,0x12,0xEF,0xCD,0xAB,0x00   /* 00000030    "xV4....." */
};

const unsigned char TemplateTpm2[] =
{
    0x54,0x50,0x4D,0x32,0x4C,0x00,0x00,0x00,  /* 00000000    "TPM2L..." */
    0x04,0xCB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x13,0x12,0x18,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x08,0x00,0x00,0x00,0x01,0x02,0x03,0x04,  /* 00000030    "........" */
    0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,  /* 00000038    "........" */
    0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00                       /* 00000048    "...."     */
};

const unsigned char TemplateUefi[] =
{
    0x55,0x45,0x46,0x49,0x36,0x00,0x00,0x00,  /* 00000000    "UEFI6..." */
    0x01,0x9B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x01,0x02,0x03,  /* 00000020    "(.. ...." */
    0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,  /* 00000028    "........" */
    0x0C,0x0D,0x0E,0x0F,0x00,0x00             /* 00000030    "......"   */
};

const unsigned char TemplateViot[] =
{
    0x56,0x49,0x4F,0x54,0x80,0x00,0x00,0x00,  /* 00000000    "VIOT...." */
    0x00,0x52,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".RINTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x05,0x01,0x21,0x20,0x04,0x00,0x30,0x00,  /* 00000020    "..! ..0." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x01,0x00,0x18,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,  /* 00000038    "........" */
    0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "`......." */
    0x02,0x00,0x18,0x00,0x00,0x00,0x01,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "p......." */
    0x03,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x04,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x1D,0x00,0x00,0x00,0x00   /* 00000078    "........" */
};

const unsigned char TemplateWaet[] =
{
    0x57,0x41,0x45,0x54,0x28,0x00,0x00,0x00,  /* 00000000    "WAET(..." */
    0x01,0x19,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00   /* 00000020    "(.. ...." */
};

const unsigned char TemplateWdat[] =
{
    0x57,0x44,0x41,0x54,0x5C,0x00,0x00,0x00,  /* 00000000    "WDAT\..." */
    0x01,0xE3,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x20,0x00,0x00,0x00,  /* 00000020    "(..  ..." */
    0xFF,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,  /* 00000028    "........" */
    0x58,0x02,0x00,0x00,0xFF,0x03,0x00,0x00,  /* 00000030    "X......." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x0E,0x00,0x00,0x00,0x01,0x02,0x00,0x00,  /* 00000040    "........" */
    0x01,0x10,0x00,0x02,0x60,0x04,0x00,0x00,  /* 00000048    "....`..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000050    "........" */
    0x01,0x00,0x00,0x00                       /* 00000058    "...."     */
};

const unsigned char TemplateWddt[] =
{
    0x57,0x44,0x44,0x54,0x40,0x00,0x00,0x00,  /* 00000000    "WDDT@..." */
    0x01,0x00,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x01,0xFF,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000038    "........" */
};

const unsigned char TemplateWdrt[] =
{
    0x57,0x44,0x52,0x54,0x47,0x00,0x00,0x00,  /* 00000000    "WDRTG..." */
    0x01,0xB0,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x20,0x00,0x00,  /* 00000020    "(.. . .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    ". ......" */
    0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0xFF,0xFF,0x00        /* 00000040    "......."  */
};

const unsigned char TemplateWpbt[] =
{
    0x57,0x50,0x42,0x54,0x98,0x00,0x00,0x00,  /* 00000000    "WPBT...." */
    0x01,0x83,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x78,0x56,0x34,0x12,  /* 00000020    "... xV4." */
    0x00,0x00,0x00,0xBB,0x00,0x00,0x00,0xAA,  /* 00000028    "........" */
    0x33,0x88,0x64,0x00,0x34,0x00,0x20,0x00,  /* 00000030    "3.d.4. ." */
    0x73,0x00,0x63,0x00,0x6F,0x00,0x72,0x00,  /* 00000038    "s.c.o.r." */
    0x65,0x00,0x20,0x00,0x61,0x00,0x6E,0x00,  /* 00000040    "e. .a.n." */
    0x64,0x00,0x20,0x00,0x37,0x00,0x20,0x00,  /* 00000048    "d. .7. ." */
    0x79,0x00,0x65,0x00,0x61,0x00,0x72,0x00,  /* 00000050    "y.e.a.r." */
    0x73,0x00,0x20,0x00,0x61,0x00,0x67,0x00,  /* 00000058    "s. .a.g." */
    0x6F,0x00,0x20,0x00,0x6F,0x00,0x75,0x00,  /* 00000060    "o. .o.u." */
    0x72,0x00,0x20,0x00,0x66,0x00,0x61,0x00,  /* 00000068    "r. .f.a." */
    0x74,0x00,0x68,0x00,0x65,0x00,0x72,0x00,  /* 00000070    "t.h.e.r." */
    0x73,0x00,0x20,0x00,0x62,0x00,0x72,0x00,  /* 00000078    "s. .b.r." */
    0x6F,0x00,0x75,0x00,0x67,0x00,0x68,0x00,  /* 00000080    "o.u.g.h." */
    0x74,0x00,0x20,0x00,0x66,0x00,0x6F,0x00,  /* 00000088    "t. .f.o." */
    0x72,0x00,0x74,0x00,0x68,0x00,0x00,0x00   /* 00000090    "r.t.h..." */
};

const unsigned char TemplateWsmt[] =
{
    0x57,0x53,0x4D,0x54,0x28,0x00,0x00,0x00,  /* 00000000    "WSMT(..." */
    0x00,0x08,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x19,0x01,0x17,0x20,0x05,0x00,0x00,0x00   /* 00000020    "... ...." */
};

const unsigned char TemplateXenv[] =
{
    0x58,0x45,0x4E,0x56,0x39,0x00,0x00,0x00,  /* 00000000    "XENV9..." */
    0x01,0x3A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".:INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x00,0x00,0x00,0x10,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x0A,0x00,0x20,0x00,0x00,  /* 00000028    "..... .." */
    0x00,0x00,0x00,0x0B,0x25,0x00,0xBB,0xAA,  /* 00000030    "....%..." */
    0x03                                      /* 00000038    "."        */
};

const unsigned char TemplateXsdt[] =
{
    0x58,0x53,0x44,0x54,0x64,0x00,0x00,0x00,  /* 00000000    "XSDTd..." */
    0x01,0x8B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x10,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,  /* 00000028    ".... ..." */
    0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,  /* 00000030    "....0..." */
    0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,  /* 00000038    "....@..." */
    0x00,0x00,0x00,0x00,0x50,0x00,0x00,0x00,  /* 00000040    "....P..." */
    0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,  /* 00000048    "....`..." */
    0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,  /* 00000050    "....p..." */
    0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00                       /* 00000060    "...."     */
};

#endif
