## Using ZeroSSL.com CA

ZeroSSL doesn't have rate limits. One can issue _unlimited_ TLS/SSL certificate valid for 90 days ([ref](https://zerossl.com/letsencrypt-alternative/#acme)).

Note: Since `v3`, `acme.sh` uses Zerossl as the default Certificate Authority (CA). Account registration (one-time) is required before one can issue new certs. See also: https://github.com/acmesh-official/acme.sh/wiki/Change-default-CA-to-ZeroSSL

### 1. Register your account.

##### 1a. With an email address

```bash
acme.sh  --register-account  -m myemail@example.com --server zerossl
```

##### 1b. With EAB credentials

Alternatively, if you sign up for a [ZeroSSL account](https://app.zerossl.com/signup), bootstrap `acme.sh` with _External Account Binding_ (EAB) credentials, like so:

1. Generate your EAB credentials from https://app.zerossl.com/developer
2. Register your EAB credentials.

```bash
acme.sh  --register-account  --server zerossl \
        --eab-kid  xxxxxxxxxxxx  \
        --eab-hmac-key  xxxxxxxxx
```

Users with a ZeroSSL account can manage issued certificates from [developer console](https://zerossl.com/features/console/).

### 2. Issue certificates

Use Zerossl.com with `--server zerossl`:

```bash
acme.sh --server zerossl  \
     --issue  -d  example.com \
     --dns dns_cf
```

If you don't want to specify `--server zerossl` every time you issue a cert, you can set `zerossl` as the default CA:

```bash
acme.sh --set-default-ca  --server zerossl
```

Read: https://github.com/acmesh-official/acme.sh/wiki/Server

Issue any cert _from_ zerossl without having to specify `--server`:

```bash
acme.sh --issue -d  example.com --dns dns_cf
```

### 3. Troubleshooting

##### Le_OrderFinalize: A KeyID must be specified
If certificate issuance fails and you see something like this in the logs
```shell
[XYZ 18 09:50:07 -02 2020] Create new order error. Le_OrderFinalize not found. 
{"type":"urn:ietf:params:acme:error:malformed","status":400,"detail":"A Key ID MUST be specified"}
```
then, re-generate your EAB credentials (refer step #2) and [re-run certificate issuance](https://github.com/acmesh-official/acme.sh/wiki/How-to-issue-a-cert). See: [acme.sh/issues/3310](https://github.com/acmesh-official/acme.sh/issues/3310#issuecomment-785374480).

----

