/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _mouse_h
#define _mouse_h

#include "pm.h"

#ifdef mouse_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Mouse-to-command response law. The current position of the mouse pointer in
 * the window is mapped to the range [-1,1] in horizontal and vertical to set
 * ailerons and elevator rotation, respectively. The mapping ranges from linear
 * (very fast response to user input, low precision) to cubic (very slow response,
 * high precision). Ailerons and elevator are in thei neutral position when the
 * mouse pointer is exactly in the middle of the window.
 */
enum {
	/** Linear. */
	mouse_FAST,
	/** Quadratic. */
	mouse_NORMAL,
	/** Cubic. */
	mouse_PRECISE
} mouse_stick_mode;

/**
 * Get stick input from mouse and set c->pitchComm, c->rollComm, and c->steerComm
 * as values in the range [-1.0 ... +1.0]. If detached, keeps the current
 * values.
 */
void mouse_getPosition(craft * c, viewer * u);

#undef EXTERN
#endif
