/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#include "XrMisc.h"
#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include <Xm/LabelG.h>
#include <Xm/TextF.h>
#include "cell.h"

extern Widget CreateExtendedFormDialog();
extern void MenuCB();

Widget
CreatePanelDialog (name, parent, p, count, calc_fn, cancel)
char	*name;
Widget	parent;
struct cell *p;
int	count;
int	calc_fn, cancel;
{
	Arg	args[10];
	char	s1[32], s2[32];
	static ActionAreaButton action_items[] = {
        	{ "Calculate",	MenuCB,	(XtPointer) NULL },
        	{ "Dismiss",	MenuCB,	(XtPointer) NULL },
        	{ "Help",	NULL,	NULL 	},
	};
	Widget	dialog, form, label;
	int	i, n;
	XmString s;
	
	count --;
	
	action_items[0].client_data = (XtPointer) calc_fn;
	action_items[1].client_data = (XtPointer) cancel;

	dialog = CreateExtendedFormDialog (name, parent, &form, action_items,
		XtNumber (action_items), 0);

	for (i=0; i<count; ++i) {

		sprintf (s1, "label_%d", i+1);
		sprintf (s2, "field_%d", i+1);

		s = XmStringCreateSimple (p[i].prompt);

		n = 0;
		XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION);  n++;
		XtSetArg (args[n], XmNrightPosition, 70); n++;
		XtSetArg (args[n], XmNlabelString, s); n++;
		if (i == 0) {
		    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM);  n++;
		}
		else {
		    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET);  n++;
		    XtSetArg (args[n], XmNtopWidget, p[i-1].field);  n++;
		}

		p[i].label = XtCreateManagedWidget (s1, xmLabelGadgetClass,
			form, args, n);

		n = 0;
		XtSetArg (args[n], XmNcolumns, p[i].field_width);  n++;
		XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION);  n++;
		XtSetArg (args[n], XmNleftPosition, 70); n++;
		if (i == 0) {
		    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM);  n++;
		}
		else {
		    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET);  n++;
		    XtSetArg (args[n], XmNtopWidget, p[i-1].field);  n++;
		}

		p[i].field = XtCreateManagedWidget (s2, xmTextFieldWidgetClass,
			form, args, n);

		XmTextFieldSetString (p[i].field,  p[i].initial_value);

	}

	XtManageChild (form);
	return dialog;
}

int
LocateCell (p, id)
struct cell *p;
int	id;
{
	int	n;
	for (n = 0; p->id >= 0; n++, p++) {
		if (id == p->id) {
			return n;
		}
	}

	fprintf (stderr, "Unable to locate cell %d\n \
Cell zero will contain invalid data\n", id);
	return 0;
}

double
GetCellValueDouble (p, n, value)
struct cell *p;
int	n;
double	*value;
{
	char	*s;

	s = XmTextFieldGetString (p[LocateCell(p, n)].field);
	*value = atof(s);
	XtFree (s);
	return *value;
}

void
SetCellValueDouble (p, n, value)
struct cell *p;
int	n;
double	value;
{
	char	s[64];

	sprintf (s, "%.8lg", value);
	XmTextFieldSetString (p[LocateCell(p, n)].field, s);
}

char *
GetCellValueString (p, n, value)
struct cell *p;
int	n;
char	*value;
{
	char	*s;

	s = XmTextFieldGetString (p[LocateCell(p, n)].field);
	strcpy (value, s);
	XtFree (s);
	return value;
}

void
SetCellValueString (p, n, value)
struct cell *p;
int	n;
char *value;
{
	XmTextFieldSetString (p[LocateCell(p, n)].field, value);
}
