!{\src2tex{textfont=tt}}
!!****f* ABINIT/linedirectint
!! NAME
!! linedirectint
!!
!! FUNCTION
!! Computes the values along a line
!! defined by its direction
!!
!! COPYRIGHT
!! Copyright (C) 2000-2007 ABINIT group (GMR,RC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! rprimd(3,3)=orientation of the unit cell in 3D
!! nr1=grid size along x
!! nr2=grid size along y
!! nr3=grid size along z
!! grid(nr1,nr2,nr3)=grid matrix
!!
!! OUTPUT
!!   only write
!!
!! PARENTS
!!      lineint
!!
!! CHILDREN
!!      interpol3d,normalize,reduce
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine linedirectint(rprimd,nr1,nr2,nr3,grid)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_11util
 use interfaces_19cut3d, except_this_one => linedirectint
#endif
!End of the abilint section

 implicit none

!Arguments-------------------------------------------------------------
!scalars
 integer,intent(in) :: nr1,nr2,nr3
!arrays
 real(dp),intent(in) :: grid(nr1,nr2,nr3),rprimd(3,3)

!Local variables--------------------------------------------------------
!scalars
 integer :: iat,idir,ii,inpopt,isp,jj,k2,nresol,okline
 real(dp) :: denval,length,xcoord,ycoord
 character(len=fnlen) :: filnam
!arrays
 real(dp) :: cent(3),r(3),rcart(3),x2(3)

! *************************************************************************

 okline=0
 do while (okline==0)
      write(*,*) 'You will enter now the line direction:'
      write(*,*) 'Type 1) for cartesian coordinates'
      write(*,*) '  or 2) for crystallographic coordinates'
      read(*,*) inpopt
  if (inpopt==1 .or. inpopt ==2) okline=1
 end do
      write(*,*) 'Type the line direction:'
      write(*,*) '    -> X-dir   Y-dir   Z-dir:'
      read(*,*) x2

 write(*,*) 'Line direction was:',x2(1),x2(2),x2(3)

     if (inpopt == 2) then
     rcart=matmul(x2,rprimd)
     x2(:)=rcart(:)
 write(*,*) 'Expressed in cartesian coordinates: ',x2(1),x2(2),x2(3)
     end if
     call normalize(x2)
!
 okline=0
 do while (okline==0)
      write(*,*) 'You will enter now the central point of line:'
      write(*,*) 'Type 1) for cartesian coordinates'
      write(*,*) '  or 2) for crystallographic coordinates'
      read(*,*) inpopt
  if (inpopt==1 .or. inpopt==2) okline=1
 end do
      write(*,*) 'Type the point coordinates:'
      write(*,*) '    -> X-Coord   Y-Coord   Z-Coord:'
      read(*,*) cent
 write(*,*) 'Central point coordinates:', cent(1),cent(2),cent(3)
      if (inpopt==2) then
      rcart=matmul(cent,rprimd)
      cent(:)=rcart(:)
 write(*,*) 'Expressed in cartesian coordinates:',cent(1),cent(2),cent(3)
      end if
!
      write(*,*) '  Enter line length:'
      read(*,*) length
      write(*,*) '  Enter line resolution:'
      read(*,*) nresol
      write(*,*) '  Enter name for output file:'
      read(*,*) filnam


! At this moment all the necessary geometric input is known
! It will calculate now the data along the line using an interpolation function
      open(unit=31,file=trim(filnam),status='unknown')
      do k2=-nresol/2,nresol/2
        rcart(1)=cent(1)+k2*x2(1)*length/nresol
        rcart(2)=cent(2)+k2*x2(2)*length/nresol
        rcart(3)=cent(3)+k2*x2(3)*length/nresol
        call reduce(r,rcart,rprimd)
        r(1)=mod(mod(r(1),1._dp)+1._dp,1._dp)
        r(2)=mod(mod(r(2),1._dp)+1._dp,1._dp)
        r(3)=mod(mod(r(3),1._dp)+1._dp,1._dp)

        xcoord=k2*length/nresol
        call interpol3d(r,nr1,nr2,nr3,denval,grid)
        write(31,1000) xcoord,denval
      end do
 1000 format(3e16.8)
      close(31)
!
      return
end subroutine linedirectint
!!***
