# -*- Autoconf -*-
#
# Copyright (c) 2005-2007 The ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# Octopus configuration variables used by the Nanoquanta XC library
#



# OCT_ETSF_XC_POINTER()
# ---------------------
#
# Checks size of pointers and sets the corresponding Fortran type
# accordingly (imported from Octopus and hacked by Yann Pouillon).
#
AC_DEFUN([OCT_ETSF_XC_POINTER],
[AC_MSG_CHECKING([for the size of a pointer])
  AC_REQUIRE([AC_PROG_CC])
  if test -z "${OCT_POINTER_SIZE}"; then
  cat >pointertest.c <<EOF
#include <stdio.h>
void main()
{
  printf("%ld", sizeof(void *));
}
EOF
  ac_try='${CC} ${CFLAGS} -o pointertest.x pointertest.c 1>&AC_FD_CC'
  if AC_TRY_EVAL(ac_try); then
    ac_try=""
  else
    echo "configure: failed program was:" >&AC_FD_CC
    cat pointertest.c >&AC_FD_CC
    rm -f pointertest*
    AC_MSG_ERROR(failed to compile C program to find the size of a pointer)
  fi
  ac_pointersize=`./pointertest.x`;
  rm -f pointertest*
  AC_DEFINE_UNQUOTED(OCT_POINTER_SIZE, ${ac_pointersize}, [Size of a C pointer])
  AC_DEFINE_UNQUOTED(C_POINTER, [integer(${ac_pointersize})], [Fortran type for a C pointer])
  AC_MSG_RESULT([${ac_pointersize} bytes])
fi
]) # OCT_ETSF_XC_POINTER
