;
; PedroM - Operating System for Ti-89/Ti-92+/V200.
; Copyright (C) 2003, 2004, 2005 Patrick Pelissier
;
; This program is free software ; you can redistribute it and/or modify it under the
; terms of the GNU General Public License as published by the Free Software Foundation;
; either version 2 of the License, or (at your option) any later version. 
; 
; This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
; See the GNU General Public License for more details. 
; 
; You should have received a copy of the GNU General Public License along with this program;
; if not, write to the 
; Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

;******************************************************************
;***                                                            ***
;***            	Main FILE				***
;***                                                            ***
;******************************************************************

PEDROM_VERSION		EQU	$0081
PEDROM_STR_VERSION	EQU	'0.81'

DEBUG_ER_THROW		EQU	0
DEBUG_LINK_COM		EQU	0
	
**********************************************************
	include	"Mem.h"			; Macros usefull for defining struct
	include	"Const.h"		; Constants 
	include "Vars.h"		; Global vars
IS_WTI		MACRO
		ENDM
	include "kheader.h"		; Kernel Header (Preos source code)
START_ARCHIVE EQU ROM_BASE+$30000	; Start of the archive!
**********************************************************
	section "_st1"
	include "Vectors.h"		; Vectors's table
**********************************************************
CODE_START:
Trap_2:
        include	"Boot.asm"		; Boot Code (Set IO ports, clear RAM, unprotect, ...) and go to the Shell Command loop - MUST BE THE FIRST INCLUDE FILE -
	include	"Flash.asm"		; Flash Code (Write to Flash, ...) - MUST BE THE SECOND INCLUDE FILE -
	include	"System.asm"		; System exec command  
	include "ShellIO.asm"		; Shell IO
	include	"Builtin.asm"		; Builtin command functions
	include "Link.asm"		; Link functions.
	include	"Strings.asm"		; String character
	include "Vat.asm"		; VAT functions.
	include "Memstr.asm"		; memcpy/strcmp/... functions
	include	"Heap.asm"		; Heap functions
	include "Graph.asm"		; Graph functions
	include	"Misc.asm"		; Various functions (1)
BASE1_END:				; End of first Base of code : MUST BE <$418000

***********************************************************
***							***
***  $418000-$419FFF       8K      [read protected]	***
***							***
***********************************************************
	section ".text"
	include "Estack.asm"		; EStack functions (1)
	include "Library.asm"		; Export API
	include "files.asm"		; Files	
	include "Kernel.asm"		; Kernel functions
	include	"printf.asm"		; Printf functions
	include "Window.asm"		; Window functions
	include "Dialog.asm"		; Dialog functions
	include "Estack2.asm"		; EStack functions (2)
	include "bitmap.asm"		; Bitmap functions
	include "Icon.asm"		; Icon functions
	include "Bcd.asm"		; Float Functions (1)
	ifnd	GPL
	include	"unpack.asm"		; Unpack (PPG) functions
	endif
	include "clipline.asm"		; ClipLine functions (Window needs DrawClipLine)
	include "ellipse.asm"		; Ellipses functions (Window needs DrawClipEllipse)
	include "Misc2.asm"		; Various functions (2)
	include "Script.asm"		; Script functions
	ifd	PEDROM_92
		include "side92.asm"	; Side for 92+
	endif
	ifd	PEDROM_89
		include	"side89.asm" ;  Side for 89
	endif
	include	"Ints.asm"		; Auto Ints 
	include	"Vectors.asm"		; Vectors (Error, traps, ...)
	include	"Process.asm"		; Process Functions
	include "qsort.asm"		; Quick Sort
	include	"Long.asm"		; Long Functions (32 bits / 32 bits, ...)
	include "md5.asm"		; MD5 Functions
	include "float.asm"		; Float functions (2)
	include "Cert.asm"		; Certificate functions.
	include "Extra.asm"		; Extra AMS 2 functions
	include	"Tib.asm"		; RAM Install code
	include	"RomVoid.asm"		; All other rom_calls 
	
***********************************************************
***			DATA				***
***********************************************************
		CNOP	0,4		; Long Alignement for DB92
MediumFont	incbin	"Fontes.bin"	; Font Data
		EVEN
	ifnd	GPL
StdLib_FILE 	incbin	"stdlib.bin"	; Standard Libraries
	endif
		EVEN
		include	"RomCalls.h"	; Romcalls table ($C8)

License_str	dc.b	"(http://www.timetoteam.fr.st)",10,10
		dc.b	"This program is free software; you can",10
		dc.b	"redistribute it and/or modify it under",10
		dc.b	"the terms of the GNU GPL as published by",10
		dc.b	"the Free Software Foundation (version 2,",10
		dc.b	"or any later version).",10,10
		dc.b	"It is distributed WITHOUT ANY WARRANTY.",10,10
		dc.b	"See http://www.gnu.org for more details.",0
		
BASE_END:				; 
		
	END
