#ifndef PDF_OR_PS_H
#define PDF_OR_PS_H

#include <FL/Fl_Paged_Device.H>

#if !(defined(__APPLE__) || defined(WIN32)) && 100*FL_MAJOR_VERSION + 10*FL_MINOR_VERSION  + FL_PATCH_VERSION == 130
// for X11 under 1.3.0 only
#include <FL/Fl_Printer.H>
class corr_Fl_Printer : public Fl_Printer {
  int count, m, M;
public:
  corr_Fl_Printer();
  int start_job(int pagecount, int *frompage=NULL, int *topage=NULL);
  int start_page();
};
#define Fl_Printer corr_Fl_Printer

class corr_Fl_PostScript_File_Device : public Fl_PostScript_File_Device {
  int count, m, M;
public:
  corr_Fl_PostScript_File_Device();
  int start_job (int pagecount, enum Fl_Paged_Device::Page_Format format=Fl_Paged_Device::A4, 
		 enum Fl_Paged_Device::Page_Layout layout=Fl_Paged_Device::PORTRAIT);
  int start_job (FILE* file, int pagecount, enum Fl_Paged_Device::Page_Format format=Fl_Paged_Device::A4, 
		 enum Fl_Paged_Device::Page_Layout layout=Fl_Paged_Device::PORTRAIT);
  int start_page();
};
#define Fl_PostScript_File_Device corr_Fl_PostScript_File_Device

#endif


#ifdef NO_PDF
#include <FL/Fl_PostScript.H>
class Fl_PDF_or_PS_File_Device : public Fl_PostScript_File_Device {
  FILE *file;
  char *filename;
public:
  Fl_PDF_or_PS_File_Device() { file = NULL; }
  int begin_document(const char* fixedfilename, enum Fl_Paged_Device::Page_Format format=Fl_Paged_Device::A4,
		     enum Fl_Paged_Device::Page_Layout layout=Fl_Paged_Device::PORTRAIT);
  int start_job(const char *defaultname, enum Fl_Paged_Device::Page_Format format=Fl_Paged_Device::A4, 
		enum Fl_Paged_Device::Page_Layout layout=Fl_Paged_Device::PORTRAIT);
  Fl_Graphics_Driver *driver() {  return Fl_PostScript_File_Device::driver(); }
  const char *outfname() {return filename; }
  ~Fl_PDF_or_PS_File_Device();
};

#else // NO_PDF

#include <setjmp.h>
class Fl_PDF_File_Device : public Fl_Paged_Device
{
  int width, height;
  Fl_Surface_Device *previous_surface;
  int left_margin, top_margin;
  char *filename;
public:
  Fl_PDF_File_Device();
  int start_job(const char *defaultname, enum Fl_Paged_Device::Page_Format format=Fl_Paged_Device::A4, 
		enum Fl_Paged_Device::Page_Layout layout=Fl_Paged_Device::PORTRAIT);
  int begin_document(const char* fixedfilename, enum Fl_Paged_Device::Page_Format format=Fl_Paged_Device::A4,
		     enum Fl_Paged_Device::Page_Layout layout=Fl_Paged_Device::PORTRAIT);
  int begin_custom(const char* fixedfilename, int pwidth, int pheight);
  int printable_rect(int *w, int *h);
  void margins(int *left, int *top, int *right, int *bottom);
  void origin(int x, int y);
  void origin (int *x, int *y);
  void translate(int x, int y);
  void untranslate();
  int start_page (void);
  int end_page (void);
  void end_job (void);
  void error_catch();
  int surface_catch();
  void surface_try(jmp_buf** b);
  void *pdf();
  const char *outfname() {return filename; }
  ~Fl_PDF_File_Device();
};
typedef Fl_PDF_File_Device Fl_PDF_or_PS_File_Device;
#endif // NO_PDF

#if defined(__APPLE__)
#include <ApplicationServices/ApplicationServices.h>
#if  (!__LP64__) && MAC_OS_X_VERSION_MAX_ALLOWED < 1070
#define USE_PICT
#endif
#endif

#if (defined(__APPLE__) || defined(WIN32))

class Fl_Copy_Surface : public Fl_Surface_Device {
#ifdef __APPLE__
  bool use_pict;
  CFMutableDataRef pdfdata;
  CGContextRef oldgc;
  CGContextRef gc;
#ifdef USE_PICT
  PicHandle mypicture;
  void MyCopyPictToClipboard();
  QDPictRef MyPictToQDPict();
#endif
  static size_t MyPutBytes (void* info, const void* buffer, size_t count);
  void prepare_copy_pdf_and_pict(int w, int h);
  void complete_copy_pdf_and_pict();
  void init_PDF_context(int w, int h);
#else
  HDC oldflgc;
#endif
public:
#ifdef __APPLE__
  Fl_Copy_Surface(bool use_pict, int w, int h);
#else
  Fl_Copy_Surface(int w, int h);
#endif
  ~Fl_Copy_Surface();
};
#endif


#endif // PDF_OR_PS_H

