#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A New Beginning
# send your bug reports to contact@dotslashplay.it
###

script_version=20240820.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='a-new-beginning'
GAME_NAME='A New Beginning'

ARCHIVE_BASE_0_NAME='setup_a_new_beginning_final_cut_2.0.4.0395_(27805).exe'
ARCHIVE_BASE_0_MD5='f914a4260284285461fa9b3cc06b88ec'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_a_new_beginning_final_cut_2.0.4.0395_(27805)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='68520b98ded6409f0c17c0204c342a45'
ARCHIVE_BASE_0_SIZE='4200000'
ARCHIVE_BASE_0_VERSION='2.0.4.0395-gog27805'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/a_new_beginning'

VISIONAIRE_NAME='anb'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Local Settings/Application Data/Daedalic Entertainment/A New Beginning - Final Cut'
## Work around audio problems
## TODO: Check if it is still required with current WINE builds
WINE_WINETRICKS_VERBS='dsound'

PKG_BIN_ARCH='32'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
