/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "SSH_Common.h"

int CF_getConfigItem(const string& configItem, string& out_str, string& errorMessage)
{
	string cmd = "grep -r "+configItem +" "+SSH_CONFIG_FILE;
	string out;
	
	CF_assert(CF_runCommandFL(cmd, out, errorMessage));
	
	out_str = out.substr(out.find(" ")+1);
	
	return OK;
}

int CF_getActiveSSHSessionItem(vector<string>& itemValue, string& errorMessage)
{
	string cmd = "netstat -tn|grep tcp|grep ':22 ' |awk '{print $5}'|grep -v :22";
	string cmd_output, stdErr;
	vector<string> output;
	
	CF_assert(CF_runCommand(cmd, cmd_output, stdErr, errorMessage));
	output.clear();
	CF_splitText(output, cmd_output, '\n');
	
	for (int i = 0; i<output.size(); i++)
	{
		if (output[i] != "")
			itemValue.push_back(output[i]);
	}
	
	return OK;
}
