/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_Slot.h"

CMPIObjectPath* PhysicalAsset_OpenDRIM_Slot_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_Slot& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_Slot_classnames[0], OpenDRIM_Slot_NAMESPACE);

	if (!instance.Tag_isNULL)
		op.addKey("Tag", instance.Tag);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	_L_;
	return op.getHdl();
}

CMPIInstance* PhysicalAsset_OpenDRIM_Slot_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_Slot& instance) {
	_E_;
	Objectpath op(broker, PhysicalAsset_OpenDRIM_Slot_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.Name_isNULL)
		ci.setProperty("Name", instance.Name);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.Manufacturer_isNULL)
		ci.setProperty("Manufacturer", instance.Manufacturer);

	if (!instance.Model_isNULL)
		ci.setProperty("Model", instance.Model);

	if (!instance.SKU_isNULL)
		ci.setProperty("SKU", instance.SKU);

	if (!instance.SerialNumber_isNULL)
		ci.setProperty("SerialNumber", instance.SerialNumber);

	if (!instance.Version_isNULL)
		ci.setProperty("Version", instance.Version);

	if (!instance.PartNumber_isNULL)
		ci.setProperty("PartNumber", instance.PartNumber);

	if (!instance.OtherIdentifyingInfo_isNULL)
		ci.setProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo);

	if (!instance.ManufactureDate_isNULL)
		ci.setPropertyDatetime("ManufactureDate", instance.ManufactureDate);

	if (!instance.VendorEquipmentType_isNULL)
		ci.setProperty("VendorEquipmentType", instance.VendorEquipmentType);

	if (!instance.UserTracking_isNULL)
		ci.setProperty("UserTracking", instance.UserTracking);

	if (!instance.CanBeFRUed_isNULL)
		ci.setProperty("CanBeFRUed", instance.CanBeFRUed);

	if (!instance.ConnectorPinout_isNULL)
		ci.setProperty("ConnectorPinout", instance.ConnectorPinout);

	if (!instance.OtherTypeDescription_isNULL)
		ci.setProperty("OtherTypeDescription", instance.OtherTypeDescription);

	if (!instance.ConnectorGender_isNULL)
		ci.setProperty("ConnectorGender", instance.ConnectorGender);

	if (!instance.ConnectorElectricalCharacteristics_isNULL)
		ci.setProperty("ConnectorElectricalCharacteristics", instance.ConnectorElectricalCharacteristics);

	if (!instance.OtherElectricalCharacteristics_isNULL)
		ci.setProperty("OtherElectricalCharacteristics", instance.OtherElectricalCharacteristics);

	if (!instance.NumPhysicalPins_isNULL)
		ci.setProperty("NumPhysicalPins", instance.NumPhysicalPins);

	if (!instance.ConnectorLayout_isNULL)
		ci.setProperty("ConnectorLayout", instance.ConnectorLayout);

	if (!instance.ConnectorDescription_isNULL)
		ci.setProperty("ConnectorDescription", instance.ConnectorDescription);

	if (!instance.ConnectorType_isNULL)
		ci.setProperty("ConnectorType", instance.ConnectorType);

	if (!instance.PoweredOn_isNULL)
		ci.setProperty("PoweredOn", instance.PoweredOn);

	if (!instance.SupportsHotPlug_isNULL)
		ci.setProperty("SupportsHotPlug", instance.SupportsHotPlug);

	if (!instance.HeightAllowed_isNULL)
		ci.setProperty("HeightAllowed", instance.HeightAllowed);

	if (!instance.LengthAllowed_isNULL)
		ci.setProperty("LengthAllowed", instance.LengthAllowed);

	if (!instance.MaxDataWidth_isNULL)
		ci.setProperty("MaxDataWidth", instance.MaxDataWidth);

	if (!instance.VccMixedVoltageSupport_isNULL)
		ci.setProperty("VccMixedVoltageSupport", instance.VccMixedVoltageSupport);

	if (!instance.VppMixedVoltageSupport_isNULL)
		ci.setProperty("VppMixedVoltageSupport", instance.VppMixedVoltageSupport);

	if (!instance.ThermalRating_isNULL)
		ci.setProperty("ThermalRating", instance.ThermalRating);

	if (!instance.SpecialPurpose_isNULL)
		ci.setProperty("SpecialPurpose", instance.SpecialPurpose);

	if (!instance.PurposeDescription_isNULL)
		ci.setProperty("PurposeDescription", instance.PurposeDescription);

	if (!instance.Number_isNULL)
		ci.setProperty("Number", instance.Number);

	if (!instance.Powered_isNULL)
		ci.setProperty("Powered", instance.Powered);

	if (!instance.OpenSwitch_isNULL)
		ci.setProperty("OpenSwitch", instance.OpenSwitch);

	if (!instance.MaxLinkWidth_isNULL)
		ci.setProperty("MaxLinkWidth", instance.MaxLinkWidth);

	if (!instance.VendorCompatibilityStrings_isNULL)
		ci.setProperty("VendorCompatibilityStrings", instance.VendorCompatibilityStrings);

	_L_;
	return ci.getHdl();
}

void PhysicalAsset_OpenDRIM_Slot_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_Slot& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (op.getKey("Tag", instance.Tag) == OK)
		instance.Tag_isNULL = false;

	_L_;
}

void PhysicalAsset_OpenDRIM_Slot_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_Slot& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("Tag", instance.Tag) == OK)
		instance.Tag_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("Manufacturer", instance.Manufacturer) == OK)
		instance.Manufacturer_isNULL = false;

	if (inst.getProperty("Model", instance.Model) == OK)
		instance.Model_isNULL = false;

	if (inst.getProperty("SKU", instance.SKU) == OK)
		instance.SKU_isNULL = false;

	if (inst.getProperty("SerialNumber", instance.SerialNumber) == OK)
		instance.SerialNumber_isNULL = false;

	if (inst.getProperty("Version", instance.Version) == OK)
		instance.Version_isNULL = false;

	if (inst.getProperty("PartNumber", instance.PartNumber) == OK)
		instance.PartNumber_isNULL = false;

	if (inst.getProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo) == OK)
		instance.OtherIdentifyingInfo_isNULL = false;

	if (inst.getPropertyDatetime("ManufactureDate", instance.ManufactureDate) == OK)
		instance.ManufactureDate_isNULL = false;

	if (inst.getProperty("VendorEquipmentType", instance.VendorEquipmentType) == OK)
		instance.VendorEquipmentType_isNULL = false;

	if (inst.getProperty("UserTracking", instance.UserTracking) == OK)
		instance.UserTracking_isNULL = false;

	if (inst.getProperty("CanBeFRUed", instance.CanBeFRUed) == OK)
		instance.CanBeFRUed_isNULL = false;

	if (inst.getProperty("ConnectorPinout", instance.ConnectorPinout) == OK)
		instance.ConnectorPinout_isNULL = false;

	if (inst.getProperty("OtherTypeDescription", instance.OtherTypeDescription) == OK)
		instance.OtherTypeDescription_isNULL = false;

	if (inst.getProperty("ConnectorGender", instance.ConnectorGender) == OK)
		instance.ConnectorGender_isNULL = false;

	if (inst.getProperty("ConnectorElectricalCharacteristics", instance.ConnectorElectricalCharacteristics) == OK)
		instance.ConnectorElectricalCharacteristics_isNULL = false;

	if (inst.getProperty("OtherElectricalCharacteristics", instance.OtherElectricalCharacteristics) == OK)
		instance.OtherElectricalCharacteristics_isNULL = false;

	if (inst.getProperty("NumPhysicalPins", instance.NumPhysicalPins) == OK)
		instance.NumPhysicalPins_isNULL = false;

	if (inst.getProperty("ConnectorLayout", instance.ConnectorLayout) == OK)
		instance.ConnectorLayout_isNULL = false;

	if (inst.getProperty("ConnectorDescription", instance.ConnectorDescription) == OK)
		instance.ConnectorDescription_isNULL = false;

	if (inst.getProperty("ConnectorType", instance.ConnectorType) == OK)
		instance.ConnectorType_isNULL = false;

	if (inst.getProperty("PoweredOn", instance.PoweredOn) == OK)
		instance.PoweredOn_isNULL = false;

	if (inst.getProperty("SupportsHotPlug", instance.SupportsHotPlug) == OK)
		instance.SupportsHotPlug_isNULL = false;

	if (inst.getProperty("HeightAllowed", instance.HeightAllowed) == OK)
		instance.HeightAllowed_isNULL = false;

	if (inst.getProperty("LengthAllowed", instance.LengthAllowed) == OK)
		instance.LengthAllowed_isNULL = false;

	if (inst.getProperty("MaxDataWidth", instance.MaxDataWidth) == OK)
		instance.MaxDataWidth_isNULL = false;

	if (inst.getProperty("VccMixedVoltageSupport", instance.VccMixedVoltageSupport) == OK)
		instance.VccMixedVoltageSupport_isNULL = false;

	if (inst.getProperty("VppMixedVoltageSupport", instance.VppMixedVoltageSupport) == OK)
		instance.VppMixedVoltageSupport_isNULL = false;

	if (inst.getProperty("ThermalRating", instance.ThermalRating) == OK)
		instance.ThermalRating_isNULL = false;

	if (inst.getProperty("SpecialPurpose", instance.SpecialPurpose) == OK)
		instance.SpecialPurpose_isNULL = false;

	if (inst.getProperty("PurposeDescription", instance.PurposeDescription) == OK)
		instance.PurposeDescription_isNULL = false;

	if (inst.getProperty("Number", instance.Number) == OK)
		instance.Number_isNULL = false;

	if (inst.getProperty("Powered", instance.Powered) == OK)
		instance.Powered_isNULL = false;

	if (inst.getProperty("OpenSwitch", instance.OpenSwitch) == OK)
		instance.OpenSwitch_isNULL = false;

	if (inst.getProperty("MaxLinkWidth", instance.MaxLinkWidth) == OK)
		instance.MaxLinkWidth_isNULL = false;

	if (inst.getProperty("VendorCompatibilityStrings", instance.VendorCompatibilityStrings) == OK)
		instance.VendorCompatibilityStrings_isNULL = false;

	_L_;
}

