#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################

if test "$3" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$3" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$3" = sfcb
then
	/etc/init.d/sfcb stop
fi

$6/registration/OpenDRIM_BootConformsToProfile.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootOrderedComponent.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootConcreteDependency.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_RegisteredBootProfile.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootConfigSetting.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootHostedService.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootSourceSetting.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootConfigSettingData.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootServiceCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootService.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootLogicalIdentity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootSettingData.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_ServiceAffectsBoot.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_BootConcreteComponent.sh $1 $2 $3 $4 $5 $6

if test "$3" = sfcb
then
	/etc/init.d/sfcb start
fi

