/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITBLP1
extends TiffProfileClassIT {
    public TiffProfileClassITBLP1() {
        this._profileText = "TIFF/IT-BL/P1 (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesNewSubfileType(tiffIFD, 0L)) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray[0] != 1) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 32898)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 0)) {
            return false;
        }
        if (!this.satisfiesOrientation(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, 1)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        int[] nArray2 = tiffIFD.getImageColorValue() != -1 ? new int[]{1} : new int[]{0, 1, 2};
        if (!this.satisfiesImageColorIndicator(tiffIFD, nArray2)) {
            return false;
        }
        nArray2 = tiffIFD.getBackgroundColorValue() != -1 ? new int[]{1} : new int[]{0, 1, 2};
        if (!this.satisfiesBackgroundColorIndicator(tiffIFD, nArray2)) {
            return false;
        }
        return tiffIFD.getDocumentName() == null && nisoImageMetadata.getScannerModelName() == null && tiffIFD.getPageName() == null && nisoImageMetadata.getHostComputer() == null && tiffIFD.getSite() == null && tiffIFD.getColorSequence() == null && tiffIFD.getIT8Header() == null;
    }
}

