/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Window;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.WindowAncestorFinder;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JMenuItemLocation;
import org.fest.swing.driver.JMenuPopupMenuQuery;
import org.fest.swing.driver.WindowMoveToFrontTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Platform;
import org.fest.util.Strings;

public class JMenuItemDriver
extends JComponentDriver {
    public JMenuItemDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void click(JMenuItem menuItem) {
        this.show(menuItem);
        this.doClick(menuItem);
        this.ensurePopupIsShowing(menuItem);
    }

    @RunsInEDT
    private void show(JMenuItem menuItem) {
        JMenuItemLocation location = JMenuItemDriver.locationOf(menuItem);
        this.activateParentIfIsAMenu(location);
        this.moveParentWindowToFront(location);
        if (menuItem instanceof JMenu && !location.inMenuBar()) {
            this.waitForSubMenuToShow();
        }
    }

    @RunsInEDT
    private static JMenuItemLocation locationOf(final JMenuItem menuItem) {
        return GuiActionRunner.execute(new GuiQuery<JMenuItemLocation>(){

            @Override
            protected JMenuItemLocation executeInEDT() {
                return new JMenuItemLocation(menuItem);
            }
        });
    }

    @RunsInEDT
    private void activateParentIfIsAMenu(JMenuItemLocation location) {
        if (!location.isParentAMenu()) {
            return;
        }
        this.click((JMenuItem)location.parentOrInvoker());
    }

    @RunsInEDT
    private void moveParentWindowToFront(JMenuItemLocation location) {
        if (!location.inMenuBar()) {
            return;
        }
        this.moveToFront(WindowAncestorFinder.windowAncestorOf(location.parentOrInvoker()));
    }

    @RunsInEDT
    private void doClick(JMenuItem menuItem) {
        if (this.isMacOSMenuBar()) {
            JMenuItemDriver.validateAndDoClick(menuItem);
            return;
        }
        super.click(menuItem);
        this.robot.waitForIdle();
    }

    private boolean isMacOSMenuBar() {
        return Platform.isOSX() && (Boolean.getBoolean("apple.laf.useScreenMenuBar") || Boolean.getBoolean("com.apple.macos.useScreenMenuBar"));
    }

    @RunsInEDT
    private static void validateAndDoClick(final JMenuItem menuItem) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(menuItem);
                menuItem.doClick();
            }
        });
    }

    @RunsInEDT
    private void ensurePopupIsShowing(JMenuItem menuItem) {
        if (!(menuItem instanceof JMenu)) {
            return;
        }
        JPopupMenu popup = JMenuPopupMenuQuery.popupMenuOf((JMenu)menuItem);
        if (!this.waitForShowing(popup, this.robot.settings().timeoutToFindPopup())) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Clicking on menu item <", Formatting.format(menuItem), "> never showed a pop-up menu"}));
        }
        this.waitForSubMenuToShow();
    }

    private void waitForSubMenuToShow() {
        Pause.pause(this.robot.settings().timeoutToFindSubMenu());
    }

    @RunsInEDT
    private void moveToFront(Window w) {
        if (w == null) {
            return;
        }
        WindowMoveToFrontTask.toFront(w);
        this.robot.waitForIdle();
        this.robot.moveMouse(w);
    }
}

