/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.ComboBoxSearchable;
import com.jidesoft.swing.DelegateAction;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.tree.TreePath;

public class AutoCompletion {
    private Searchable _searchable;
    private JTextComponent _textComponent;
    private AutoCompletionDocument _document;
    private boolean _selecting = false;
    private boolean _hidePopupOnFocusLoss;
    private boolean _keyTyped = false;
    private boolean _hitBackspace = false;
    private boolean _hitBackspaceOnSelection;
    private KeyListener _editorKeyListener;
    private boolean _strict = true;
    private boolean _strictCompletion = true;
    private PropertyChangeListener _propertyChangeListener;
    private JComboBox _comboBox;
    private Document _oldDocument;
    public static final String CLIENT_PROPERTY_AUTO_COMPLETION = "AutoCompletion";

    public AutoCompletion(JComboBox jComboBox) {
        this(jComboBox, (Searchable)new ComboBoxSearchable(jComboBox));
    }

    public AutoCompletion(JComboBox jComboBox, Searchable searchable) {
        this._searchable = searchable;
        this._propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("editor".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() != null) {
                    AutoCompletion.this._textComponent = (JTextComponent)((ComboBoxEditor)propertyChangeEvent.getNewValue()).getEditorComponent();
                    AutoCompletion.this.configureEditor(AutoCompletion.this.getTextComponent());
                }
            }
        };
        this._comboBox = jComboBox;
        this._searchable.setWildcardEnabled(false);
        if (this._searchable instanceof ComboBoxSearchable) {
            ((ComboBoxSearchable)this._searchable).setShowPopupDuringSearching(false);
        }
        this._textComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        this.installListeners();
    }

    public AutoCompletion(JTextComponent jTextComponent, Searchable searchable) {
        this._searchable = searchable;
        this._searchable.setWildcardEnabled(false);
        this._textComponent = jTextComponent;
        this.registerSelectionListener(this.getSearchable());
        this.installListeners();
    }

    public AutoCompletion(JTextComponent jTextComponent, final List list) {
        this(jTextComponent, new Searchable((JComponent)new JLabel()){
            int _selectIndex;
            {
                super(jComponent);
                this._selectIndex = -1;
            }

            @Override
            protected int getSelectedIndex() {
                return this._selectIndex;
            }

            @Override
            protected void setSelectedIndex(int n, boolean bl) {
                this._selectIndex = n;
            }

            @Override
            protected int getElementCount() {
                return list.size();
            }

            @Override
            protected Object getElementAt(int n) {
                return list.get(n);
            }

            @Override
            protected String convertElementToString(Object object) {
                return "" + object;
            }
        });
    }

    public AutoCompletion(JTextComponent jTextComponent, final Object[] objectArray) {
        this(jTextComponent, new Searchable((JComponent)new JLabel()){
            int _selectIndex;
            {
                super(jComponent);
                this._selectIndex = -1;
            }

            @Override
            protected int getSelectedIndex() {
                return this._selectIndex;
            }

            @Override
            protected void setSelectedIndex(int n, boolean bl) {
                this._selectIndex = n;
            }

            @Override
            protected int getElementCount() {
                return objectArray.length;
            }

            @Override
            protected Object getElementAt(int n) {
                return objectArray[n];
            }

            @Override
            protected String convertElementToString(Object object) {
                return "" + object;
            }
        });
    }

    private void registerSelectionListener(Searchable searchable) {
        if (searchable.getComponent() instanceof JList) {
            final JList jList = (JList)this.getSearchable().getComponent();
            jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = jList.getSelectedIndex();
                    if (n != -1) {
                        AutoCompletion.this.getTextComponent().setText(AutoCompletion.this.getSearchable().convertElementToString(jList.getModel().getElementAt(n)));
                        AutoCompletion.this.highlightCompletedText(0);
                    }
                }
            });
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(38, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(40, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(33, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jList, 0, KeyStroke.getKeyStroke(34, 0));
        } else if (searchable.getComponent() instanceof JTree) {
            final JTree jTree = (JTree)this.getSearchable().getComponent();
            jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    TreePath treePath = jTree.getSelectionPath();
                    if (treePath != null) {
                        AutoCompletion.this.getTextComponent().setText("" + treePath.getLastPathComponent());
                        AutoCompletion.this.highlightCompletedText(0);
                    } else {
                        AutoCompletion.this.getTextComponent().setText("");
                    }
                }
            });
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(38, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(40, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(33, 0));
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 1, jTree, 0, KeyStroke.getKeyStroke(34, 0));
        }
    }

    private boolean isKeyTyped() {
        return this._keyTyped;
    }

    private void setKeyTyped(boolean bl) {
        this._keyTyped = bl;
    }

    private void setInitValue() {
        int n = this.getSearchable().getSelectedIndex();
        if (n != -1) {
            Object object = this.getSearchable().getElementAt(n);
            if (object != null) {
                this._document.setText(this.getSearchable().convertElementToString(object));
            }
            this.highlightCompletedText(0);
        } else {
            this._document.setText("");
        }
    }

    public void uninstallListeners() {
        if (this._propertyChangeListener != null && this._comboBox != null) {
            this._comboBox.removePropertyChangeListener(this._propertyChangeListener);
        }
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeKeyListener(this._editorKeyListener);
            String string = this.getTextComponent().getText();
            if (this._oldDocument != null) {
                this.getTextComponent().setDocument(this._oldDocument);
                this._oldDocument = null;
            }
            this.getTextComponent().setText(string);
        }
        this.getTextComponent().putClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION, null);
    }

    public void installListeners() {
        if (this._comboBox != null && this._propertyChangeListener != null) {
            this._comboBox.addPropertyChangeListener(this._propertyChangeListener);
        }
        this._editorKeyListener = new KeyAdapter(){
            private boolean _deletePressed;
            private String _saveText;

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AutoCompletion.this._hitBackspace = false;
                if (27 != keyEvent.getKeyCode()) {
                    AutoCompletion.this.setKeyTyped(true);
                }
                switch (keyEvent.getKeyCode()) {
                    case 8: {
                        if (!AutoCompletion.this.isStrict()) break;
                        AutoCompletion.this._hitBackspace = true;
                        AutoCompletion.this._hitBackspaceOnSelection = AutoCompletion.this.getTextComponent().getSelectionStart() != AutoCompletion.this.getTextComponent().getSelectionEnd();
                        break;
                    }
                    case 127: {
                        if (!AutoCompletion.this.isStrict()) break;
                        this._deletePressed = true;
                        this._saveText = AutoCompletion.this.getTextComponent().getText();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                try {
                    if (this._deletePressed) {
                        this._deletePressed = false;
                        String string = AutoCompletion.this.getTextComponent().getText();
                        int n = AutoCompletion.this.getSearchable().findFirst(string);
                        if (n != -1) {
                            if (string.length() == 0) {
                                AutoCompletion.this.setSelectedItem("");
                            } else {
                                Object object = AutoCompletion.this.getSearchable().getElementAt(n);
                                AutoCompletion.this.setSelectedItem(object);
                                AutoCompletion.this.getTextComponent().setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                                AutoCompletion.this.highlightCompletedText(string.length());
                            }
                        } else if (AutoCompletion.this.isStrict()) {
                            AutoCompletion.this.getTextComponent().setText(this._saveText);
                            keyEvent.consume();
                            PortingUtils.notifyUser(AutoCompletion.this._textComponent);
                        }
                    }
                }
                finally {
                    if (27 != keyEvent.getKeyCode()) {
                        AutoCompletion.this.setKeyTyped(false);
                    }
                }
            }
        };
        this._hidePopupOnFocusLoss = SystemInfo.isJdk15Above();
        this._document = this.createDocument();
        this.configureEditor(this.getTextComponent());
        this.getTextComponent().putClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION, this);
    }

    protected AutoCompletionDocument createDocument() {
        return new AutoCompletionDocument();
    }

    private void configureEditor(JTextComponent jTextComponent) {
        if (this.getTextComponent() != null) {
            this.getTextComponent().removeKeyListener(this._editorKeyListener);
        }
        if (jTextComponent != null) {
            this._textComponent = jTextComponent;
            this.getTextComponent().addKeyListener(this._editorKeyListener);
            String string = this.getTextComponent().getText();
            this._oldDocument = this.getTextComponent().getDocument();
            if (this._oldDocument instanceof AbstractDocument && this._document != null) {
                this._document.setDocumentFilter(((AbstractDocument)this._oldDocument).getDocumentFilter());
            }
            this.getTextComponent().setDocument(this._document);
            this.getTextComponent().setText(string);
        }
    }

    private void highlightCompletedText(int n) {
        int n2 = this.getTextComponent().getDocument().getLength();
        this.getTextComponent().setCaretPosition(n2);
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        this.getTextComponent().moveCaretPosition(n);
    }

    private void setSelectedItem(Object object) {
        this._selecting = true;
        int n = this.getSearchable().getElementCount();
        for (int i = 0; i < n; ++i) {
            Object object2 = this.getSearchable().getElementAt(i);
            if (!JideSwingUtilities.equals(object, object2)) continue;
            this.getSearchable().setSelectedIndex(i, false);
        }
        this._selecting = false;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean bl) {
        this._strict = bl;
    }

    public boolean isStrictCompletion() {
        return this._strictCompletion;
    }

    public void setStrictCompletion(boolean bl) {
        this._strictCompletion = bl;
    }

    protected JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public Searchable getSearchable() {
        return this._searchable;
    }

    public static AutoCompletion getAutoCompletion(JComponent jComponent) {
        if (jComponent == null) {
            return null;
        }
        Object object = jComponent.getClientProperty(CLIENT_PROPERTY_AUTO_COMPLETION);
        if (object instanceof AutoCompletion) {
            return (AutoCompletion)object;
        }
        return null;
    }

    protected class AutoCompletionDocument
    extends PlainDocument {
        protected AutoCompletionDocument() {
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            if (AutoCompletion.this._selecting) {
                return;
            }
            if (AutoCompletion.this._hitBackspace) {
                if (n > 0) {
                    if (AutoCompletion.this._hitBackspaceOnSelection) {
                        --n;
                    }
                } else {
                    PortingUtils.notifyUser(AutoCompletion.this._textComponent);
                }
                AutoCompletion.this.highlightCompletedText(n);
            } else {
                super.remove(n, n2);
            }
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (AutoCompletion.this._selecting) {
                return;
            }
            super.insertString(n, string, attributeSet);
            if (AutoCompletion.this.isKeyTyped() || AutoCompletion.this.isStrict()) {
                String string2 = this.getText(0, this.getLength());
                int n2 = AutoCompletion.this.getSearchable().findFirstExactly(string2);
                if (n2 != -1) {
                    return;
                }
                int n3 = AutoCompletion.this.getSearchable().findFromCursor(string2);
                if (n3 != -1) {
                    Object object = AutoCompletion.this.getSearchable().getElementAt(n3);
                    AutoCompletion.this.setSelectedItem(object);
                    this.setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                    AutoCompletion.this.highlightCompletedText(n + string.length());
                } else if (AutoCompletion.this.isStrict()) {
                    if (n == 0 && string2.equals(string)) {
                        AutoCompletion.this.getSearchable().textChanged("");
                        n3 = AutoCompletion.this.getSearchable().findFromCursor(string2);
                        if (n3 != -1) {
                            Object object = AutoCompletion.this.getSearchable().getElementAt(n3);
                            AutoCompletion.this.setSelectedItem(object);
                            this.setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                            AutoCompletion.this.highlightCompletedText(n + string.length());
                        } else if (AutoCompletion.this.isStrict()) {
                            n3 = AutoCompletion.this.getSearchable().getSelectedIndex();
                            if (n3 == -1 && AutoCompletion.this.getSearchable().getElementCount() > 0) {
                                n3 = 0;
                                AutoCompletion.this.getSearchable().setSelectedIndex(0, false);
                            }
                            if (n3 != -1) {
                                Object object = AutoCompletion.this.getSearchable().getElementAt(n3);
                                PortingUtils.notifyUser(AutoCompletion.this._textComponent);
                                this.setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                                AutoCompletion.this.highlightCompletedText((n -= string.length()) + string.length());
                            }
                        }
                        return;
                    }
                    n3 = AutoCompletion.this.getSearchable().getSelectedIndex();
                    if (n3 == -1 && AutoCompletion.this.getSearchable().getElementCount() > 0) {
                        n3 = 0;
                        AutoCompletion.this.getSearchable().setSelectedIndex(0, false);
                    }
                    if (n3 != -1) {
                        Object object = AutoCompletion.this.getSearchable().getElementAt(n3);
                        PortingUtils.notifyUser(AutoCompletion.this._textComponent);
                        this.setText(AutoCompletion.this.getSearchable().convertElementToString(object));
                        AutoCompletion.this.highlightCompletedText((n -= string.length()) + string.length());
                    }
                }
            }
        }

        protected void setText(String string) {
            try {
                if (AutoCompletion.this.isStrictCompletion()) {
                    super.remove(0, this.getLength());
                    super.insertString(0, string, null);
                } else {
                    String string2 = super.getText(0, this.getLength());
                    int n = string2.length() <= string.length() ? string2.length() : string.length();
                    for (int i = 0; i < string2.length(); ++i) {
                        if (string2.substring(0, n).equalsIgnoreCase(string.substring(0, n))) continue;
                        --n;
                    }
                    super.remove(n, this.getLength() - n);
                    super.insertString(n, string.substring(n), null);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException.toString());
            }
        }
    }
}

