/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.InputStream;
import proguard.classfile.util.ClassUtil;
import proguard.io.DataEntry;

public class ClassPathDataEntry
implements DataEntry {
    private final String name;
    private InputStream inputStream;

    public ClassPathDataEntry(Class clazz) {
        this(ClassUtil.internalClassName(clazz.getName()) + ".class");
    }

    public ClassPathDataEntry(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginalName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.getClass().getClassLoader().getResourceAsStream(this.name);
        }
        return this.inputStream;
    }

    @Override
    public void closeInputStream() throws IOException {
        this.inputStream.close();
        this.inputStream = null;
    }

    @Override
    public DataEntry getParent() {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

