/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "lt" locale.
 */
public class DateTimeFormatInfoImpl_lt extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "pr.p.",
        "pop."
    };
  }

  @Override
  public String dateFormatFull() {
    return "y 'm'. MMMM d 'd'.,EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "y 'm'. MMMM d 'd'.";
  }

  @Override
  public String dateFormatMedium() {
    return "yyyy.MM.dd";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "prieš Kristų",
        "po Kristaus"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "pr. Kr.",
        "po Kr."
    };
  }

  @Override
  public String formatHour12Minute() {
    return "hh:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "hh:mm:ss a";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "MMM-d";
  }

  @Override
  public String formatMonthFullDay() {
    return "MMMM-d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M.d";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y 'm'. MMM d 'd'.";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y 'm'. MMMM d 'd'.";
  }

  @Override
  public String formatYearMonthNum() {
    return "y.M";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y.M.d";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y 'm'. MMM d 'd'.,EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "sausis",
        "vasaris",
        "kovas",
        "balandis",
        "gegužė",
        "birželis",
        "liepa",
        "rugpjūtis",
        "rugsėjis",
        "spalis",
        "lapkritis",
        "gruodis"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "Sausis",
        "Vasaris",
        "Kovas",
        "Balandis",
        "Gegužė",
        "Birželis",
        "Liepa",
        "Rugpjūtis",
        "Rugsėjis",
        "Spalis",
        "Lapkritis",
        "Gruodis"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "S",
        "V",
        "K",
        "B",
        "G",
        "B",
        "L",
        "R",
        "R",
        "S",
        "L",
        "G"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "Sau",
        "Vas",
        "Kov",
        "Bal",
        "Geg",
        "Bir",
        "Lie",
        "Rgp",
        "Rgs",
        "Spl",
        "Lap",
        "Grd"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "Saus.",
        "Vas.",
        "kov",
        "Bal.",
        "Geg.",
        "Bir.",
        "Liep.",
        "Rugpj.",
        "Rugs.",
        "Spal.",
        "Lapkr.",
        "Gruod."
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "pirmas ketvirtis",
        "antras ketvirtis",
        "trečias ketvirtis",
        "ketvirtas ketvirtis"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "K1",
        "K2",
        "K3",
        "K4"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "sekmadienis",
        "pirmadienis",
        "antradienis",
        "trečiadienis",
        "ketvirtadienis",
        "penktadienis",
        "šeštadienis"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "P",
        "A",
        "T",
        "K",
        "P",
        "Š"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "Sk",
        "Pr",
        "An",
        "Tr",
        "Kt",
        "Pn",
        "Št"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return new String[] {
        "Sk",
        "Pi",
        "A",
        "T",
        "K",
        "Pe",
        "Š"
    };
  }
}
