/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.server.Message;
import com.google.gwt.i18n.server.MessageTranslation;
import com.google.gwt.i18n.shared.AlternateMessageSelector;
import com.google.gwt.i18n.shared.GwtLocale;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringMapMessageTranslation
implements MessageTranslation {
    private final String defaultMessage;
    private final List<String> forms;
    private final Map<String, String> map;
    private final GwtLocale locale;

    public StringMapMessageTranslation(String defaultMessage, List<String> forms, Map<String, String> map, GwtLocale locale) {
        this.defaultMessage = defaultMessage;
        this.forms = forms;
        this.map = map;
        this.locale = locale;
    }

    @Override
    public Iterable<Message.AlternateFormMapping> getAllMessageForms() {
        return new Iterable<Message.AlternateFormMapping>(){
            protected final Iterator<String> iter;
            {
                this.iter = StringMapMessageTranslation.this.forms.iterator();
            }

            @Override
            public Iterator<Message.AlternateFormMapping> iterator() {
                return new Iterator<Message.AlternateFormMapping>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public Message.AlternateFormMapping next() {
                        String form = iter.next();
                        return new Message.AlternateFormMapping(Arrays.asList(new AlternateMessageSelector.AlternateForm(form, form)), (String)StringMapMessageTranslation.this.map.get(form));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public GwtLocale getMatchedLocale() {
        return this.locale;
    }
}

