/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ee" locale.
 */
public class LocalizedNamesImpl_ee extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "IS",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AX",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BL",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "BV",
        "CC",
        "CP",
        "CX",
        "DK",
        "DG",
        "DM",
        "DO",
        "DJ",
        "EA",
        "TL",
        "EG",
        "EH",
        "EC",
        "GQ",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FJ",
        "FI",
        "FO",
        "FR",
        "GF",
        "PF",
        "GA",
        "GM",
        "GE",
        "DE",
        "GG",
        "GH",
        "GI",
        "GW",
        "GL",
        "GR",
        "GD",
        "GS",
        "GP",
        "GU",
        "GT",
        "GN",
        "GY",
        "JM",
        "JP",
        "JO",
        "HT",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IM",
        "ID",
        "IN",
        "IQ",
        "IR",
        "IE",
        "IT",
        "IL",
        "JE",
        "KH",
        "CM",
        "CA",
        "CV",
        "QA",
        "KY",
        "KZ",
        "KE",
        "KI",
        "CO",
        "KM",
        "CD",
        "CG",
        "CK",
        "CR",
        "CI",
        "HR",
        "CU",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "LS",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MH",
        "MQ",
        "MK",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MS",
        "MA",
        "MZ",
        "MM",
        "MR",
        "MU",
        "NA",
        "NR",
        "AN",
        "NL",
        "NP",
        "NC",
        "NZ",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "MP",
        "KP",
        "NO",
        "OM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "QO",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "CF",
        "CS",
        "SC",
        "SL",
        "SG",
        "SJ",
        "SK",
        "SI",
        "SB",
        "SO",
        "ZA",
        "KR",
        "ES",
        "LK",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "CY",
        "SY",
        "TA",
        "TJ",
        "TW",
        "TZ",
        "TF",
        "TH",
        "TG",
        "TK",
        "TO",
        "TT",
        "TD",
        "CZ",
        "CL",
        "CN",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "UM",
        "AE",
        "GB",
        "UY",
        "US",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andorradu");
    namesMap.put("AE", "United Arab Emiratesdu");
    namesMap.put("AF", "Afghanistadu");
    namesMap.put("AG", "Antigua kplɛ Barbudadukɔwo");
    namesMap.put("AI", "Anguilladu");
    namesMap.put("AL", "Albaniadu");
    namesMap.put("AM", "Armeniadu");
    namesMap.put("AN", "Nedalands Antilisdu");
    namesMap.put("AO", "Angoladu");
    namesMap.put("AR", "Argentinadu");
    namesMap.put("AS", "Amerika Samoadu");
    namesMap.put("AT", "Austriadu");
    namesMap.put("AU", "Australiadu");
    namesMap.put("AW", "Arubadu");
    namesMap.put("AZ", "Azerbaigyandu");
    namesMap.put("BA", "Bosnia kplɛ Herzegovinadukɔwo");
    namesMap.put("BB", "Barbadosdu");
    namesMap.put("BD", "Bangladesidu");
    namesMap.put("BE", "Belgiumdu");
    namesMap.put("BF", "Burkina Fasodu");
    namesMap.put("BG", "Bulgaridu");
    namesMap.put("BH", "Bahraindu");
    namesMap.put("BI", "Burundidu");
    namesMap.put("BJ", "Benindu");
    namesMap.put("BM", "Bermudadu");
    namesMap.put("BN", "Bruneidu");
    namesMap.put("BO", "Boliviadu");
    namesMap.put("BR", "Brazildu");
    namesMap.put("BS", "Bahamasdu");
    namesMap.put("BT", "Bhutandu");
    namesMap.put("BW", "Botswanadu");
    namesMap.put("BY", "Belarusdu");
    namesMap.put("BZ", "Belizidu");
    namesMap.put("CA", "Kanadadu");
    namesMap.put("CD", "Kongo Demokratik Repɔblikdu");
    namesMap.put("CF", "Sentral Afrikan Republikdu");
    namesMap.put("CG", "Kongodu");
    namesMap.put("CH", "Switzerland-du");
    namesMap.put("CI", "Kote d'ivoiredu");
    namesMap.put("CK", "Kook Ailandsdukɔwo");
    namesMap.put("CL", "Tsilidu");
    namesMap.put("CM", "Kamerundu");
    namesMap.put("CN", "Tsinadu");
    namesMap.put("CO", "Kolombiadu");
    namesMap.put("CR", "Kosta Rikadu");
    namesMap.put("CS", "Serbia kplɛ Montenegrodukɔwo");
    namesMap.put("CU", "kubadu");
    namesMap.put("CV", "Kape Verde Ailandsdukɔwo");
    namesMap.put("CY", "Syprusdu");
    namesMap.put("CZ", "Tsek Repɔblikdu");
    namesMap.put("DE", "Germanidu");
    namesMap.put("DJ", "Dzibutidu");
    namesMap.put("DK", "Denmarkdu");
    namesMap.put("DM", "Dominikadu");
    namesMap.put("DO", "Dominika Repɔblikdu");
    namesMap.put("DZ", "Algeriadu");
    namesMap.put("EC", "Ekuadɔdu");
    namesMap.put("EE", "Estoniadu");
    namesMap.put("EG", "Egyptdu");
    namesMap.put("ER", "Eritreadu");
    namesMap.put("ES", "Spaindu");
    namesMap.put("ET", "Etiopiadu");
    namesMap.put("FI", "Finland-du");
    namesMap.put("FJ", "Fidzidu");
    namesMap.put("FK", "Falklanɖ Ailandsdukɔwo");
    namesMap.put("FM", "Mikronesiadu");
    namesMap.put("FR", "Fransdu");
    namesMap.put("GA", "Gabɔndu");
    namesMap.put("GB", "United Kingdomdu");
    namesMap.put("GD", "Grenadadu");
    namesMap.put("GE", "Georgiadu");
    namesMap.put("GF", "Frentsi Guianadu");
    namesMap.put("GH", "Ghanadu");
    namesMap.put("GI", "Gibraltadu");
    namesMap.put("GL", "Greenland-du");
    namesMap.put("GM", "Gambiadu");
    namesMap.put("GN", "Guinidu");
    namesMap.put("GP", "Guadelupedu");
    namesMap.put("GQ", "Ekuatorial Ginidu");
    namesMap.put("GR", "Greesidu");
    namesMap.put("GT", "Guatemayadu");
    namesMap.put("GU", "Guamdu");
    namesMap.put("GW", "Gini-Bisaodu");
    namesMap.put("GY", "Guyanadu");
    namesMap.put("HN", "Hondurasdu");
    namesMap.put("HR", "Kroashiadu");
    namesMap.put("HT", "Haitidu");
    namesMap.put("HU", "Hungaridu");
    namesMap.put("ID", "Indonesiadu");
    namesMap.put("IE", "Ireland-du");
    namesMap.put("IL", "Izraldu");
    namesMap.put("IN", "Inɖiadu");
    namesMap.put("IO", "British India Oshiin Territorydu");
    namesMap.put("IQ", "Irakdu");
    namesMap.put("IR", "Irandu");
    namesMap.put("IS", "Aiselanddu");
    namesMap.put("IT", "Italidu");
    namesMap.put("JM", "Gyamaikadu");
    namesMap.put("JO", "Gyɔdandu");
    namesMap.put("JP", "Gyapandu");
    namesMap.put("KE", "Kenyadu");
    namesMap.put("KG", "Kyrgyzstandu");
    namesMap.put("KH", "Kambodiadu");
    namesMap.put("KI", "Kiribatidu");
    namesMap.put("KM", "Komorosdu");
    namesMap.put("KN", "Saint Kitis kplɛ Nevisdukɔwo");
    namesMap.put("KP", "North Koreadu");
    namesMap.put("KR", "South Koreadu");
    namesMap.put("KW", "Kuwaitdu");
    namesMap.put("KY", "Kayman Ailandsdukɔwo");
    namesMap.put("KZ", "Kazakstandu");
    namesMap.put("LA", "Laosdu");
    namesMap.put("LB", "Lebanɔndu");
    namesMap.put("LC", "Saint Lusiadu");
    namesMap.put("LI", "Litsensteindu");
    namesMap.put("LK", "Sri Lankadu");
    namesMap.put("LR", "Liberiadu");
    namesMap.put("LS", "Lɛsotodu");
    namesMap.put("LT", "Lituaniadu");
    namesMap.put("LU", "Luxembɔgdu");
    namesMap.put("LV", "Latviadu");
    namesMap.put("LY", "Libyadu");
    namesMap.put("MA", "Morokodu");
    namesMap.put("MC", "Monakodu");
    namesMap.put("MD", "Moldovadu");
    namesMap.put("MG", "Madagaskadu");
    namesMap.put("MH", "Marshal Aislandsdu");
    namesMap.put("MK", "Masedoniadu");
    namesMap.put("ML", "Malidu");
    namesMap.put("MM", "Myanmardu");
    namesMap.put("MN", "Mongoliadu");
    namesMap.put("MP", "Norh Mariana Ailandukɔwo");
    namesMap.put("MQ", "Martinikidu");
    namesMap.put("MR", "Mɔritaniadu");
    namesMap.put("MS", "Montserratdu");
    namesMap.put("MT", "Maltadu");
    namesMap.put("MU", "Mɔritiusdu");
    namesMap.put("MV", "Maldivisdu");
    namesMap.put("MW", "Malawidu");
    namesMap.put("MX", "Mesikodu");
    namesMap.put("MY", "Malaysiadu");
    namesMap.put("MZ", "Mozambikidu");
    namesMap.put("NA", "Namibiadu");
    namesMap.put("NC", "New Kaledoniadu");
    namesMap.put("NE", "Nigerdu");
    namesMap.put("NF", "Norfolk Ailanddu");
    namesMap.put("NG", "Nigeriadu");
    namesMap.put("NI", "Nikaraguadu");
    namesMap.put("NL", "Nedalandsdu");
    namesMap.put("NO", "Norwaydu");
    namesMap.put("NP", "Nepaldu");
    namesMap.put("NR", "Naurudu");
    namesMap.put("NU", "Niuedu");
    namesMap.put("NZ", "New Zealand-du");
    namesMap.put("OM", "Omandu");
    namesMap.put("PA", "Panamadu");
    namesMap.put("PE", "Perudu");
    namesMap.put("PF", "Frentsi Polynesiadu");
    namesMap.put("PG", "Papua New Guineadu");
    namesMap.put("PH", "Philipinsdu");
    namesMap.put("PK", "Pakistandu");
    namesMap.put("PL", "Polandu");
    namesMap.put("PM", "Saint Pierre kplɛ Mikelɔndukɔwo");
    namesMap.put("PN", "Pitkairndu");
    namesMap.put("PR", "Puerto Rikodu");
    namesMap.put("PS", "Palestinia West Bank kplɛ Gazadukɔwo");
    namesMap.put("PT", "Portugaldu");
    namesMap.put("PW", "Palaudu");
    namesMap.put("PY", "Paraguadu");
    namesMap.put("QA", "Katadu");
    namesMap.put("RE", "Reuniondu");
    namesMap.put("RO", "Romaniadu");
    namesMap.put("RU", "Russiadu");
    namesMap.put("RW", "Rwandadu");
    namesMap.put("SA", "Saudi Arabiadu");
    namesMap.put("SB", "Solomon Ailandukɔwo");
    namesMap.put("SC", "Seyshɛlsdu");
    namesMap.put("SD", "Sudandu");
    namesMap.put("SE", "Swedendu");
    namesMap.put("SG", "Singapɔrdu");
    namesMap.put("SH", "Saint Helenadu");
    namesMap.put("SI", "Sloveniadu");
    namesMap.put("SK", "Slovakiadu");
    namesMap.put("SL", "Sierra Leonedu");
    namesMap.put("SM", "San Marinodu");
    namesMap.put("SN", "Senegaldu");
    namesMap.put("SO", "Somaliadu");
    namesMap.put("SR", "Surinamedu");
    namesMap.put("ST", "Sao Tome kplɛ Prinsipidukɔwo");
    namesMap.put("SV", "El Savadɔdu");
    namesMap.put("SY", "Syriadu");
    namesMap.put("SZ", "Swaziland-du");
    namesMap.put("TC", "Turks kplɛ kaikos Islandsdukɔwo");
    namesMap.put("TD", "Tsad-du");
    namesMap.put("TG", "Togodu");
    namesMap.put("TH", "Thailand-du");
    namesMap.put("TJ", "Taghikistandu");
    namesMap.put("TK", "Tokelaudu");
    namesMap.put("TL", "East Timordu");
    namesMap.put("TM", "Turkmenistandu");
    namesMap.put("TN", "Tunisiadu");
    namesMap.put("TO", "Tongadu");
    namesMap.put("TR", "Turkeedu");
    namesMap.put("TT", "Trinidad kplɛ Tobagodukɔwo");
    namesMap.put("TV", "Tuvaludu");
    namesMap.put("TW", "Taiwandu");
    namesMap.put("TZ", "Tanzaniadu");
    namesMap.put("UA", "Ukrainedu");
    namesMap.put("UG", "Ugandadu");
    namesMap.put("US", "USA-dukɔwo");
    namesMap.put("UY", "Uruguaydu");
    namesMap.put("UZ", "Uzbekistandu");
    namesMap.put("VA", "Vatikan Statedu");
    namesMap.put("VC", "Saint Vinsent kplɛ Grenadinisdukɔwo");
    namesMap.put("VE", "Venezueladu");
    namesMap.put("VG", "British Virgin Islandsdukɔwo");
    namesMap.put("VI", "U.S Virgin Islandsdukɔwo");
    namesMap.put("VN", "Vietnamdu");
    namesMap.put("VU", "Vanuatudu");
    namesMap.put("WF", "Wallis kplɛ Futunadu");
    namesMap.put("WS", "Samoadu");
    namesMap.put("YE", "Yemendu");
    namesMap.put("YT", "Mayotidu");
    namesMap.put("ZA", "South Afrikadu");
    namesMap.put("ZM", "Zambiadu");
    namesMap.put("ZW", "Zimbabwedu");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andorradu",
        "AE": "United Arab Emiratesdu",
        "AF": "Afghanistadu",
        "AG": "Antigua kplɛ Barbudadukɔwo",
        "AI": "Anguilladu",
        "AL": "Albaniadu",
        "AM": "Armeniadu",
        "AN": "Nedalands Antilisdu",
        "AO": "Angoladu",
        "AR": "Argentinadu",
        "AS": "Amerika Samoadu",
        "AT": "Austriadu",
        "AU": "Australiadu",
        "AW": "Arubadu",
        "AZ": "Azerbaigyandu",
        "BA": "Bosnia kplɛ Herzegovinadukɔwo",
        "BB": "Barbadosdu",
        "BD": "Bangladesidu",
        "BE": "Belgiumdu",
        "BF": "Burkina Fasodu",
        "BG": "Bulgaridu",
        "BH": "Bahraindu",
        "BI": "Burundidu",
        "BJ": "Benindu",
        "BM": "Bermudadu",
        "BN": "Bruneidu",
        "BO": "Boliviadu",
        "BR": "Brazildu",
        "BS": "Bahamasdu",
        "BT": "Bhutandu",
        "BW": "Botswanadu",
        "BY": "Belarusdu",
        "BZ": "Belizidu",
        "CA": "Kanadadu",
        "CD": "Kongo Demokratik Repɔblikdu",
        "CF": "Sentral Afrikan Republikdu",
        "CG": "Kongodu",
        "CH": "Switzerland-du",
        "CI": "Kote d'ivoiredu",
        "CK": "Kook Ailandsdukɔwo",
        "CL": "Tsilidu",
        "CM": "Kamerundu",
        "CN": "Tsinadu",
        "CO": "Kolombiadu",
        "CR": "Kosta Rikadu",
        "CS": "Serbia kplɛ Montenegrodukɔwo",
        "CU": "kubadu",
        "CV": "Kape Verde Ailandsdukɔwo",
        "CY": "Syprusdu",
        "CZ": "Tsek Repɔblikdu",
        "DE": "Germanidu",
        "DJ": "Dzibutidu",
        "DK": "Denmarkdu",
        "DM": "Dominikadu",
        "DO": "Dominika Repɔblikdu",
        "DZ": "Algeriadu",
        "EC": "Ekuadɔdu",
        "EE": "Estoniadu",
        "EG": "Egyptdu",
        "ER": "Eritreadu",
        "ES": "Spaindu",
        "ET": "Etiopiadu",
        "FI": "Finland-du",
        "FJ": "Fidzidu",
        "FK": "Falklanɖ Ailandsdukɔwo",
        "FM": "Mikronesiadu",
        "FR": "Fransdu",
        "GA": "Gabɔndu",
        "GB": "United Kingdomdu",
        "GD": "Grenadadu",
        "GE": "Georgiadu",
        "GF": "Frentsi Guianadu",
        "GH": "Ghanadu",
        "GI": "Gibraltadu",
        "GL": "Greenland-du",
        "GM": "Gambiadu",
        "GN": "Guinidu",
        "GP": "Guadelupedu",
        "GQ": "Ekuatorial Ginidu",
        "GR": "Greesidu",
        "GT": "Guatemayadu",
        "GU": "Guamdu",
        "GW": "Gini-Bisaodu",
        "GY": "Guyanadu",
        "HN": "Hondurasdu",
        "HR": "Kroashiadu",
        "HT": "Haitidu",
        "HU": "Hungaridu",
        "ID": "Indonesiadu",
        "IE": "Ireland-du",
        "IL": "Izraldu",
        "IN": "Inɖiadu",
        "IO": "British India Oshiin Territorydu",
        "IQ": "Irakdu",
        "IR": "Irandu",
        "IS": "Aiselanddu",
        "IT": "Italidu",
        "JM": "Gyamaikadu",
        "JO": "Gyɔdandu",
        "JP": "Gyapandu",
        "KE": "Kenyadu",
        "KG": "Kyrgyzstandu",
        "KH": "Kambodiadu",
        "KI": "Kiribatidu",
        "KM": "Komorosdu",
        "KN": "Saint Kitis kplɛ Nevisdukɔwo",
        "KP": "North Koreadu",
        "KR": "South Koreadu",
        "KW": "Kuwaitdu",
        "KY": "Kayman Ailandsdukɔwo",
        "KZ": "Kazakstandu",
        "LA": "Laosdu",
        "LB": "Lebanɔndu",
        "LC": "Saint Lusiadu",
        "LI": "Litsensteindu",
        "LK": "Sri Lankadu",
        "LR": "Liberiadu",
        "LS": "Lɛsotodu",
        "LT": "Lituaniadu",
        "LU": "Luxembɔgdu",
        "LV": "Latviadu",
        "LY": "Libyadu",
        "MA": "Morokodu",
        "MC": "Monakodu",
        "MD": "Moldovadu",
        "MG": "Madagaskadu",
        "MH": "Marshal Aislandsdu",
        "MK": "Masedoniadu",
        "ML": "Malidu",
        "MM": "Myanmardu",
        "MN": "Mongoliadu",
        "MP": "Norh Mariana Ailandukɔwo",
        "MQ": "Martinikidu",
        "MR": "Mɔritaniadu",
        "MS": "Montserratdu",
        "MT": "Maltadu",
        "MU": "Mɔritiusdu",
        "MV": "Maldivisdu",
        "MW": "Malawidu",
        "MX": "Mesikodu",
        "MY": "Malaysiadu",
        "MZ": "Mozambikidu",
        "NA": "Namibiadu",
        "NC": "New Kaledoniadu",
        "NE": "Nigerdu",
        "NF": "Norfolk Ailanddu",
        "NG": "Nigeriadu",
        "NI": "Nikaraguadu",
        "NL": "Nedalandsdu",
        "NO": "Norwaydu",
        "NP": "Nepaldu",
        "NR": "Naurudu",
        "NU": "Niuedu",
        "NZ": "New Zealand-du",
        "OM": "Omandu",
        "PA": "Panamadu",
        "PE": "Perudu",
        "PF": "Frentsi Polynesiadu",
        "PG": "Papua New Guineadu",
        "PH": "Philipinsdu",
        "PK": "Pakistandu",
        "PL": "Polandu",
        "PM": "Saint Pierre kplɛ Mikelɔndukɔwo",
        "PN": "Pitkairndu",
        "PR": "Puerto Rikodu",
        "PS": "Palestinia West Bank kplɛ Gazadukɔwo",
        "PT": "Portugaldu",
        "PW": "Palaudu",
        "PY": "Paraguadu",
        "QA": "Katadu",
        "RE": "Reuniondu",
        "RO": "Romaniadu",
        "RU": "Russiadu",
        "RW": "Rwandadu",
        "SA": "Saudi Arabiadu",
        "SB": "Solomon Ailandukɔwo",
        "SC": "Seyshɛlsdu",
        "SD": "Sudandu",
        "SE": "Swedendu",
        "SG": "Singapɔrdu",
        "SH": "Saint Helenadu",
        "SI": "Sloveniadu",
        "SK": "Slovakiadu",
        "SL": "Sierra Leonedu",
        "SM": "San Marinodu",
        "SN": "Senegaldu",
        "SO": "Somaliadu",
        "SR": "Surinamedu",
        "ST": "Sao Tome kplɛ Prinsipidukɔwo",
        "SV": "El Savadɔdu",
        "SY": "Syriadu",
        "SZ": "Swaziland-du",
        "TC": "Turks kplɛ kaikos Islandsdukɔwo",
        "TD": "Tsad-du",
        "TG": "Togodu",
        "TH": "Thailand-du",
        "TJ": "Taghikistandu",
        "TK": "Tokelaudu",
        "TL": "East Timordu",
        "TM": "Turkmenistandu",
        "TN": "Tunisiadu",
        "TO": "Tongadu",
        "TR": "Turkeedu",
        "TT": "Trinidad kplɛ Tobagodukɔwo",
        "TV": "Tuvaludu",
        "TW": "Taiwandu",
        "TZ": "Tanzaniadu",
        "UA": "Ukrainedu",
        "UG": "Ugandadu",
        "US": "USA-dukɔwo",
        "UY": "Uruguaydu",
        "UZ": "Uzbekistandu",
        "VA": "Vatikan Statedu",
        "VC": "Saint Vinsent kplɛ Grenadinisdukɔwo",
        "VE": "Venezueladu",
        "VG": "British Virgin Islandsdukɔwo",
        "VI": "U.S Virgin Islandsdukɔwo",
        "VN": "Vietnamdu",
        "VU": "Vanuatudu",
        "WF": "Wallis kplɛ Futunadu",
        "WS": "Samoadu",
        "YE": "Yemendu",
        "YT": "Mayotidu",
        "ZA": "South Afrikadu",
        "ZM": "Zambiadu",
        "ZW": "Zimbabwedu"
    };
  }-*/;
}
